/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.adapters.platformAdapter;

import BlockDynasty.adapters.GUI.listener.ClickListener;
import BlockDynasty.adapters.GUI.listener.CloseListener;
import java.util.UUID;
import lib.abstractions.IPlayer;
import lib.commands.abstractions.IEntityCommands;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IInventory;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.item.inventory.menu.InventoryMenu;
import org.spongepowered.api.item.inventory.menu.handler.CloseHandler;
import org.spongepowered.api.item.inventory.menu.handler.SlotClickHandler;
import org.spongepowered.api.item.inventory.type.ViewableInventory;

public class EntityPlayerAdapter
implements IPlayer {
    ServerPlayer player;

    private EntityPlayerAdapter(ServerPlayer player) {
        this.player = player;
    }

    public static EntityPlayerAdapter of(ServerPlayer player) {
        return new EntityPlayerAdapter(player);
    }

    @Override
    public boolean isOnline() {
        return this.player.isOnline();
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public void kickPlayer(String message) {
        this.player.kick((Component)Component.text((String)message));
    }

    @Override
    public UUID getUniqueId() {
        return this.player.uniqueId();
    }

    @Override
    public String getName() {
        return this.player.name();
    }

    @Override
    public void sendMessage(String message) {
        Component textonuevo = MiniMessage.miniMessage().deserialize((Object)message);
        this.player.sendMessage(textonuevo);
    }

    @Override
    public void playNotificationSound() {
        Sound sound = Sound.sound((Key)ResourceKey.resolve((String)"minecraft:block.note_block.pling"), (Sound.Source)Sound.Source.PLAYER, (float)1.0f, (float)1.5f);
        this.player.playSound(sound);
    }

    @Override
    public void playSuccessSound() {
        Sound sound = Sound.sound((Key)ResourceKey.resolve((String)"minecraft:ui.button.click"), (Sound.Source)Sound.Source.PLAYER, (float)0.3f, (float)1.0f);
        this.player.playSound(sound);
    }

    @Override
    public void playFailureSound() {
        Sound sound = Sound.sound((Key)ResourceKey.resolve((String)"minecraft:block.note_block.pling"), (Sound.Source)Sound.Source.PLAYER, (float)0.3f, (float)0.5f);
        this.player.playSound(sound);
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    @Override
    public void openInventory(IInventory inventory) {
        if (!(inventory.getHandle() instanceof ViewableInventory)) {
            throw new IllegalArgumentException("Invalid inventory type provided");
        }
        ViewableInventory spongeInventory = (ViewableInventory)inventory.getHandle();
        InventoryMenu menu = spongeInventory.asMenu();
        menu.setReadOnly(true).setTitle((Component)Component.text((String)inventory.getTitle()));
        menu.registerSlotClick((SlotClickHandler)new ClickListener());
        menu.registerClose((CloseHandler)new CloseListener());
        menu.open(this.player);
    }

    @Override
    public IEntityCommands asEntityCommands() {
        return this;
    }

    @Override
    public IEntityGUI asEntityGUI() {
        return this;
    }

    @Override
    public Object getRoot() {
        return this.player;
    }
}

