/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.redis.clients.jedis.executors;

import com.BlockDynasty.redis.clients.jedis.CommandObject;
import com.BlockDynasty.redis.clients.jedis.Connection;
import com.BlockDynasty.redis.clients.jedis.ConnectionPool;
import com.BlockDynasty.redis.clients.jedis.HostAndPort;
import com.BlockDynasty.redis.clients.jedis.annots.VisibleForTesting;
import com.BlockDynasty.redis.clients.jedis.exceptions.JedisBroadcastException;
import com.BlockDynasty.redis.clients.jedis.exceptions.JedisClusterOperationException;
import com.BlockDynasty.redis.clients.jedis.executors.CommandExecutor;
import com.BlockDynasty.redis.clients.jedis.providers.ClusterConnectionProvider;
import com.BlockDynasty.slf4j.Logger;
import com.BlockDynasty.slf4j.LoggerFactory;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;

public class ClusterCommandExecutor
implements CommandExecutor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public final ClusterConnectionProvider provider;
    protected final int maxAttempts;
    protected final Duration maxTotalRetriesDuration;

    public ClusterCommandExecutor(ClusterConnectionProvider provider, int maxAttempts, Duration maxTotalRetriesDuration) {
        this.provider = provider;
        this.maxAttempts = maxAttempts;
        this.maxTotalRetriesDuration = maxTotalRetriesDuration;
    }

    @Override
    public void close() {
        this.provider.close();
    }

    @Override
    public final <T> T broadcastCommand(CommandObject<T> commandObject) {
        Map<String, ConnectionPool> connectionMap = this.provider.getConnectionMap();
        boolean isErrored = false;
        Object reply = null;
        JedisBroadcastException bcastError = new JedisBroadcastException();
        for (Map.Entry<String, ConnectionPool> entry : connectionMap.entrySet()) {
            HostAndPort node = HostAndPort.from(entry.getKey());
            ConnectionPool pool = entry.getValue();
            try {
                Connection connection = pool.getResource();
                Throwable throwable = null;
                try {
                    T aReply = this.execute(connection, commandObject);
                    bcastError.addReply(node, aReply);
                    if (isErrored) continue;
                    if (reply == null) {
                        reply = aReply;
                        continue;
                    }
                    if (reply.equals(aReply)) continue;
                    isErrored = true;
                    reply = null;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (Exception anError) {
                bcastError.addReply(node, anError);
                isErrored = true;
            }
        }
        if (isErrored) {
            throw bcastError;
        }
        return (T)reply;
    }

    @Override
    public final <T> T executeCommand(CommandObject<T> commandObject) {
        return this.doExecuteCommand(commandObject, false);
    }

    public final <T> T executeCommandToReplica(CommandObject<T> commandObject) {
        return this.doExecuteCommand(commandObject, true);
    }

    /*
     * Exception decompiling
     */
    private <T> T doExecuteCommand(CommandObject<T> commandObject, boolean toReplica) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    protected <T> T execute(Connection connection, CommandObject<T> commandObject) {
        return connection.executeCommand(commandObject);
    }

    private boolean handleConnectionProblem(int attemptsLeft, int consecutiveConnectionFailures, Instant doneDeadline) {
        if (this.maxAttempts < 3) {
            if (attemptsLeft == 0) {
                this.provider.renewSlotCache();
                return true;
            }
            return false;
        }
        if (consecutiveConnectionFailures < 2) {
            return false;
        }
        this.sleep(ClusterCommandExecutor.getBackoffSleepMillis(attemptsLeft, doneDeadline));
        this.provider.renewSlotCache();
        return true;
    }

    private static long getBackoffSleepMillis(int attemptsLeft, Instant deadline) {
        if (attemptsLeft <= 0) {
            return 0L;
        }
        long millisLeft = Duration.between(Instant.now(), deadline).toMillis();
        if (millisLeft < 0L) {
            throw new JedisClusterOperationException("Cluster retry deadline exceeded.");
        }
        long maxBackOff = millisLeft / (long)(attemptsLeft * attemptsLeft);
        return ThreadLocalRandom.current().nextLong(maxBackOff + 1L);
    }

    @VisibleForTesting
    protected void sleep(long sleepMillis) {
        try {
            TimeUnit.MILLISECONDS.sleep(sleepMillis);
        }
        catch (InterruptedException e) {
            throw new JedisClusterOperationException(e);
        }
    }
}

