/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand;

import BlockDynasty.Economy.aplication.useCase.transaction.interfaces.IWithdrawUseCase;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import lib.abstractions.IPlayer;
import lib.commands.CommandsFactory;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.messages.MessageService;

public class BuyCommand
extends AbstractCommand {
    private final IWithdrawUseCase withdraw;

    public BuyCommand(IWithdrawUseCase withdraw) {
        super("buy", "", List.of("player", "amount", "currency", "command..."));
        this.withdraw = withdraw;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        double cantidadDemoneda;
        if (!super.execute(sender, args)) {
            return false;
        }
        IPlayer player = CommandsFactory.getPlatformAdapter().getPlayer(args[0]);
        if (player == null) {
            sender.sendMessage("player is offline");
            return false;
        }
        try {
            cantidadDemoneda = Double.parseDouble(args[1]);
        }
        catch (NumberFormatException e) {
            player.sendMessage(MessageService.getMessage("invalidamount"));
            return false;
        }
        String tipoDemoneda = args[2];
        StringBuilder cmdBuilder = new StringBuilder();
        for (int i = 3; i < args.length; ++i) {
            cmdBuilder.append(args[i]).append(" ");
        }
        String cmd = cmdBuilder.toString().trim();
        Result<Void> result = this.withdraw.execute(player.getName(), tipoDemoneda, BigDecimal.valueOf(cantidadDemoneda));
        if (result.isSuccess()) {
            try {
                CommandsFactory.getPlatformAdapter().dispatchCommand(cmd);
                player.sendMessage(MessageService.getMessage("buy_success"));
            }
            catch (Exception e) {
                sender.sendMessage("Error dispatch command: " + e.getMessage());
            }
        } else {
            sender.sendMessage("Error: " + result.getErrorMessage());
        }
        return true;
    }
}

