/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class SetDefaultCommand
extends AbstractCommand {
    private final EditCurrencyUseCase editCurrencyUseCase;

    public SetDefaultCommand(EditCurrencyUseCase editCurrencyUseCase) {
        super("default", "", List.of("currency"));
        this.editCurrencyUseCase = editCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        try {
            this.editCurrencyUseCase.setDefaultCurrency(currencyName);
            sender.sendMessage("Set default currency to " + currencyName);
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Unknown currency");
        }
        catch (TransactionException e) {
            sender.sendMessage("Error while setting default currency");
        }
        return true;
    }
}

