/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.Result;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class ViewCommand
extends AbstractCommand {
    private final SearchCurrencyUseCase searchCurrencyUseCase;

    public ViewCommand(SearchCurrencyUseCase searchCurrencyUseCase) {
        super("view", "", List.of("currency"));
        this.searchCurrencyUseCase = searchCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        Result<Currency> resultCurrency = this.searchCurrencyUseCase.getCurrency(args[0]);
        if (!resultCurrency.isSuccess()) {
            sender.sendMessage(resultCurrency.getErrorMessage() + " " + String.valueOf((Object)resultCurrency.getErrorCode()));
            return false;
        }
        Currency currency = resultCurrency.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ChatColor.stringValueOf(Colors.GREEN) + "--- Currency Info ---").append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "ID: " + ChatColor.stringValueOf(Colors.RED) + currency.getUuid().toString()).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Singular: " + currency.getSingular() + ", Plural: " + currency.getPlural()).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Color: " + ChatColor.stringValueOf(currency.getColor()) + currency.getColor()).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Symbol: " + currency.getSymbol()).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Start Balance: " + currency.format(currency.getDefaultBalance())).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Decimals: " + (currency.isDecimalSupported() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No")).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Default: " + (currency.isDefaultCurrency() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No")).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Payable: " + (currency.isTransferable() ? ChatColor.stringValueOf(Colors.GREEN) + "Yes" : ChatColor.stringValueOf(Colors.RED) + "No")).append("\n").append(ChatColor.stringValueOf(Colors.GRAY) + "Rate: " + currency.getExchangeRate());
        sender.sendMessage(stringBuilder.toString());
        return true;
    }
}

