/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.users.OfferSubCommand;

import BlockDynasty.Economy.aplication.useCase.offer.CancelOfferUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.result.Result;
import java.util.List;
import lib.abstractions.IPlayer;
import lib.commands.CommandsFactory;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class DenyOfferCommand
extends AbstractCommand {
    private final CancelOfferUseCase cancelOfferUseCase;

    public DenyOfferCommand(CancelOfferUseCase cancelOfferUseCase) {
        super("deny", "", List.of("player"));
        this.cancelOfferUseCase = cancelOfferUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String playerNme = args[0];
        IPlayer playerFrom = CommandsFactory.getPlatformAdapter().getPlayer(playerNme);
        if (playerFrom == null || !playerFrom.isOnline()) {
            sender.sendMessage("player offline");
            return false;
        }
        Player player = new Player(playerFrom.getUniqueId(), playerFrom.getName());
        Result<Void> result = this.cancelOfferUseCase.execute(player);
        if (!result.isSuccess()) {
            sender.sendMessage(result.getErrorMessage() + " " + String.valueOf((Object)result.getErrorCode()));
            return false;
        }
        return true;
    }
}

