/*
 * Decompiled with CFR 0.152.
 */
package lib.gui;

import BlockDynasty.Economy.aplication.useCase.UseCaseFactory;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import java.util.UUID;
import lib.abstractions.IMessages;
import lib.abstractions.PlatformAdapter;
import lib.gui.GUIService;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IGUIService;
import lib.gui.components.ITextInput;
import lib.gui.components.abstractions.AbstractPanel;
import lib.gui.templates.administrators.mainMenus.AccountSelectorToEdit;
import lib.gui.templates.administrators.mainMenus.CurrencyAdminPanel;
import lib.gui.templates.administrators.mainMenus.EconomyAdminPanel;
import lib.gui.templates.administrators.subMenus.accounts.DepositPanel;
import lib.gui.templates.administrators.subMenus.accounts.EditAccountPanel;
import lib.gui.templates.administrators.subMenus.accounts.SetBalancePanel;
import lib.gui.templates.administrators.subMenus.accounts.WithdrawPanel;
import lib.gui.templates.administrators.subMenus.currencies.ColorSelectionPanel;
import lib.gui.templates.administrators.subMenus.currencies.CreateCurrencyGUI;
import lib.gui.templates.administrators.subMenus.currencies.CurrencyListDelete;
import lib.gui.templates.administrators.subMenus.currencies.CurrencyListEdit;
import lib.gui.templates.administrators.subMenus.currencies.EditCurrencyPanel;
import lib.gui.templates.users.AccountBalance;
import lib.gui.templates.users.BankPanel;
import lib.gui.templates.users.CurrencyListToPay;
import lib.gui.templates.users.Exchange.ExchangeFirstPanel;
import lib.gui.templates.users.ListPlayersFromDb;
import lib.gui.templates.users.ListPlayersOnline;
import lib.gui.templates.users.Offers.CreateOfferFirstPanel;
import lib.gui.templates.users.Offers.MyActiveOffers;
import lib.gui.templates.users.Offers.ReceivedOffers;
import lib.util.colors.Message;

public class GUIFactory {
    private static ITextInput textInput;
    private static final IGUIService guiService;
    private static UseCaseFactory useCaseFactory;

    public static void init(UseCaseFactory useCaseFactory, ITextInput textInput, PlatformAdapter adapter, IMessages messages) {
        Message.addLang(messages);
        AbstractPanel.setPlatformAdapter(adapter, guiService);
        GUIFactory.useCaseFactory = useCaseFactory;
        GUIFactory.textInput = textInput;
    }

    public static IGUIService getGuiService() {
        return guiService;
    }

    public static IGUI economyAdminPanel(IEntityGUI sender) {
        return new EconomyAdminPanel(sender);
    }

    public static IGUI accountSelectorToEdit(IEntityGUI sender, IGUI parent) {
        return new AccountSelectorToEdit(sender, useCaseFactory.searchAccount(), parent, textInput);
    }

    public static IGUI editAccountPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new EditAccountPanel(useCaseFactory.deleteAccount(), useCaseFactory.editAccount(), useCaseFactory.searchAccount(), sender, target, parent, textInput);
    }

    public static IGUI balancePanel(IEntityGUI sender, UUID target, IGUI parent) {
        return new AccountBalance(sender, target, useCaseFactory.getBalance(), parent);
    }

    public static IGUI depositPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new DepositPanel(sender, target, useCaseFactory.searchCurrency(), useCaseFactory.deposit(), parent, textInput);
    }

    public static IGUI setPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new SetBalancePanel(sender, target, useCaseFactory.searchCurrency(), useCaseFactory.setBalance(), parent, textInput);
    }

    public static IGUI withdrawPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new WithdrawPanel(sender, target, useCaseFactory.searchCurrency(), useCaseFactory.withdraw(), parent, textInput);
    }

    public static IGUI currencyPanel(IEntityGUI player, IGUI parent) {
        return new CurrencyAdminPanel(player, parent);
    }

    public static void createCurrencyPanel(IEntityGUI sender, IGUI parent) {
        new CreateCurrencyGUI(sender, useCaseFactory.createCurrency(), useCaseFactory.searchCurrency(), parent, textInput);
    }

    public static IGUI currencyListToDeletePanel(IEntityGUI player, IGUI parent) {
        return new CurrencyListDelete(player, useCaseFactory.searchCurrency(), useCaseFactory.deleteCurrency(), parent, textInput);
    }

    public static IGUI currencyListToEditPanel(IEntityGUI player, IGUI parent) {
        return new CurrencyListEdit(player, useCaseFactory.searchCurrency(), parent, textInput);
    }

    public static IGUI editCurrencyPanel(IEntityGUI sender, Currency currency, IGUI parent) {
        return new EditCurrencyPanel(sender, currency, useCaseFactory.editCurrency(), parent, textInput);
    }

    public static IGUI colorSelectorPanel(IEntityGUI sender, Currency currency, EditCurrencyPanel parent) {
        return new ColorSelectionPanel(sender, currency, useCaseFactory.editCurrency(), parent, textInput);
    }

    public static IGUI bankPanel(IEntityGUI sender) {
        return new BankPanel(sender, useCaseFactory.searchAccount(), textInput);
    }

    public static IGUI createOfferFirstPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new CreateOfferFirstPanel(sender, target, useCaseFactory.searchCurrency(), useCaseFactory.createOffer(), parent, textInput);
    }

    public static IGUI balancePanel(IEntityGUI sender, IGUI parent) {
        return new AccountBalance(sender, useCaseFactory.getBalance(), parent);
    }

    public static IGUI listPlayersFromDb(IEntityGUI sender, IGUI parent) {
        return new ListPlayersFromDb(sender, parent, useCaseFactory.searchAccount(), textInput);
    }

    public static IGUI exchangeFirstPanel(IEntityGUI sender, IGUI parent) {
        return new ExchangeFirstPanel(sender, useCaseFactory.searchCurrency(), useCaseFactory.exchange(), parent, textInput);
    }

    public static IGUI receivedOffers(IEntityGUI sender, IGUI parent) {
        return new ReceivedOffers(useCaseFactory.searchOffer(), useCaseFactory.acceptOffer(), useCaseFactory.cancelOffer(), sender, parent);
    }

    public static IGUI myActiveOffers(IEntityGUI sender, IGUI parent) {
        return new MyActiveOffers(useCaseFactory.searchOffer(), useCaseFactory.cancelOffer(), sender, parent);
    }

    public static IGUI myActiveOffers(IEntityGUI sender) {
        return new MyActiveOffers(useCaseFactory.searchOffer(), useCaseFactory.cancelOffer(), sender, null);
    }

    public static IGUI listPlayersOnline(IEntityGUI sender, IGUI parent) {
        return new ListPlayersOnline(sender, parent, textInput);
    }

    public static IGUI currencyListToPayPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new CurrencyListToPay(sender, target, useCaseFactory.searchCurrency(), useCaseFactory.pay(), parent, textInput);
    }

    static {
        guiService = new GUIService();
    }
}

