/*
 * Decompiled with CFR 0.152.
 */
package lib.gui;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lib.gui.components.ClickType;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IGUIService;

public class GUIService
implements IGUIService {
    private final Map<UUID, IGUI> openGUIs = new ConcurrentHashMap<UUID, IGUI>();

    @Override
    public void registerGUI(IEntityGUI player, IGUI gui) {
        this.openGUIs.put(player.getUniqueId(), gui);
    }

    @Override
    public void unregisterGUI(IEntityGUI player) {
        this.openGUIs.remove(player.getUniqueId());
    }

    @Override
    public boolean hasOpenedGUI(IEntityGUI player) {
        return this.openGUIs.containsKey(player.getUniqueId());
    }

    @Override
    public void handleClick(IEntityGUI player, ClickType clickType, int indexSlot) {
        IGUI gui = this.openGUIs.get(player.getUniqueId());
        if (gui != null) {
            if (ClickType.LEFT == clickType) {
                gui.handleLeftClick(indexSlot, player);
            } else if (ClickType.RIGHT == clickType) {
                gui.handleRightClick(indexSlot, player);
            }
        }
    }

    @Override
    public void refresh(UUID playerId) {
        IGUI gui = this.openGUIs.get(playerId);
        if (gui != null) {
            gui.refresh();
        }
    }
}

