/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.currencies;

import BlockDynasty.Economy.aplication.useCase.currency.CreateCurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyException;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class CreateCurrencyGUI {
    private final IEntityGUI player;
    private final CreateCurrencyUseCase createCurrencyUseCase;
    private String singularName;
    private final IGUI parent;
    private final ITextInput textInput;

    public CreateCurrencyGUI(IEntityGUI player, CreateCurrencyUseCase createCurrencyUseCase, SearchCurrencyUseCase searchCurrencyUseCase, IGUI parent, ITextInput textInput) {
        this.parent = parent;
        this.player = player;
        this.textInput = textInput;
        this.createCurrencyUseCase = createCurrencyUseCase;
        this.openSingularNameInput();
    }

    private void openSingularNameInput() {
        this.textInput.open(this.parent, this.player, "Singular Name", "Name..", s -> {
            this.singularName = s.trim();
            this.openPluralNameInput();
            return null;
        });
    }

    private void openPluralNameInput() {
        this.textInput.open(this.player, "Plural Name", "Name..", s -> {
            this.createCurrency(this.singularName, s.trim());
            return null;
        });
    }

    private void createCurrency(String singular, String plural) {
        try {
            this.createCurrencyUseCase.execute(singular, plural);
            this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "The currency " + singular + ChatColor.stringValueOf(Colors.GREEN) + " has been created successfully.");
            GUIFactory.currencyPanel(this.player, this.parent).open();
        }
        catch (CurrencyException e) {
            this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error creating currency: " + ChatColor.stringValueOf(Colors.YELLOW) + e.getMessage());
            this.player.closeInventory();
        }
    }
}

