/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.domain.entities.account.Player;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AccountsList;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public class ListPlayersOnline
extends AccountsList {
    private final IEntityGUI sender;

    public ListPlayersOnline(IEntityGUI sender, IGUI parent, ITextInput textInput) {
        super(Message.process("listPlayersOnline.title"), 5, sender, parent, textInput);
        this.sender = sender;
        List<Player> players = platformAdapter.getOnlinePlayers().stream().map(p -> new Player(p.getUniqueId(), p.getName())).sorted((a, b) -> a.getNickname().compareToIgnoreCase(b.getNickname())).collect(Collectors.toList());
        this.showPlayers(players);
    }

    @Override
    public Player findPlayerByName(String playerName) {
        IEntityGUI target = platformAdapter.getOnlinePlayers().stream().filter(p -> p.getName().equalsIgnoreCase(playerName)).findFirst().orElse(null);
        if (target != null) {
            return new Player(target.getUniqueId(), target.getName());
        }
        return null;
    }

    @Override
    public void openNextSection(Player target) {
        GUIFactory.currencyListToPayPanel(this.sender, target, this.getParent()).open();
    }

    @Override
    public void addCustomButtons() {
        super.addCustomButtons();
        this.setItem(4, this.createItem(Materials.PAPER, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "listPlayersOnline.button1.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "listPlayersOnline.button1.lore")), null);
    }
}

