/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.ResourceStreamLocator;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.internal.ContextProvidingValidationEventHandler;
import org.hibernate.boot.jaxb.internal.stax.BufferedXMLEventReader;
import org.hibernate.boot.jaxb.internal.stax.LocalXmlResourceResolver;
import org.hibernate.boot.jaxb.spi.Binder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public abstract class AbstractBinder<T>
implements Binder<T> {
    private static final Logger log = Logger.getLogger(AbstractBinder.class);
    private final LocalXmlResourceResolver xmlResourceResolver;
    private XMLInputFactory staxFactory;

    protected AbstractBinder(ResourceStreamLocator resourceStreamLocator) {
        this.xmlResourceResolver = new LocalXmlResourceResolver(resourceStreamLocator);
    }

    public abstract boolean isValidationEnabled();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <X extends T> Binding<X> bind(InputStream stream, Origin origin) {
        XMLEventReader eventReader = this.createReader(stream, origin);
        try {
            Binding<X> binding = this.doBind(eventReader, origin);
            return binding;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.debug((Object)"Unable to close StAX reader", e);
            }
        }
    }

    protected XMLEventReader createReader(InputStream stream, Origin origin) {
        try {
            XMLEventReader staxReader = this.staxFactory().createXMLEventReader(stream);
            return new BufferedXMLEventReader(staxReader, 100);
        }
        catch (XMLStreamException e) {
            throw new MappingException("Unable to create StAX reader", e, origin);
        }
    }

    @Override
    public <X extends T> Binding<X> bind(Source source, Origin origin) {
        XMLEventReader eventReader = this.createReader(source, origin);
        return this.doBind(eventReader, origin);
    }

    protected XMLEventReader createReader(Source source, Origin origin) {
        try {
            XMLEventReader staxReader = this.staxFactory().createXMLEventReader(source);
            return new BufferedXMLEventReader(staxReader, 100);
        }
        catch (XMLStreamException e) {
            throw new MappingException("Unable to create StAX reader", e, origin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X extends T> Binding<X> doBind(XMLEventReader eventReader, Origin origin) {
        try {
            StartElement rootElementStartEvent = this.seekRootElementStartEvent(eventReader, origin);
            Binding<X> binding = this.doBind(eventReader, rootElementStartEvent, origin);
            return binding;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (Exception e) {
                log.debug((Object)"Unable to close StAX reader", e);
            }
        }
    }

    private XMLInputFactory staxFactory() {
        if (this.staxFactory == null) {
            this.staxFactory = this.buildStaxFactory();
        }
        return this.staxFactory;
    }

    private XMLInputFactory buildStaxFactory() {
        XMLInputFactory staxFactory = XMLInputFactory.newInstance();
        staxFactory.setXMLResolver(this.xmlResourceResolver);
        return staxFactory;
    }

    protected StartElement seekRootElementStartEvent(XMLEventReader staxEventReader, Origin origin) {
        XMLEvent rootElementStartEvent;
        try {
            rootElementStartEvent = staxEventReader.peek();
            while (rootElementStartEvent != null && !rootElementStartEvent.isStartElement()) {
                staxEventReader.nextEvent();
                rootElementStartEvent = staxEventReader.peek();
            }
        }
        catch (Exception e) {
            throw new MappingException("Error accessing StAX stream", e, origin);
        }
        if (rootElementStartEvent == null) {
            throw new MappingException("Could not locate root element", origin);
        }
        return rootElementStartEvent.asStartElement();
    }

    protected abstract <X extends T> Binding<X> doBind(XMLEventReader var1, StartElement var2, Origin var3);

    protected static boolean hasNamespace(StartElement startElement) {
        return StringHelper.isNotEmpty(startElement.getName().getNamespaceURI());
    }

    protected <X extends T> X jaxb(XMLEventReader reader, Schema xsd, JAXBContext jaxbContext, Origin origin) {
        ContextProvidingValidationEventHandler handler = new ContextProvidingValidationEventHandler();
        try {
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            if (this.isValidationEnabled()) {
                unmarshaller.setSchema(xsd);
            } else {
                unmarshaller.setSchema(null);
            }
            unmarshaller.setEventHandler(handler);
            return (X)unmarshaller.unmarshal(reader);
        }
        catch (JAXBException e) {
            throw new MappingException("Unable to perform unmarshalling at line number " + handler.getLineNumber() + " and column " + handler.getColumnNumber() + ". Message: " + handler.getMessage(), e, origin);
        }
    }
}

