/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.FunctionExpression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class FirebirdSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private boolean inFunction;

    public FirebirdSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        if (this.getDialect().getVersion().isSameOrAfter(3)) {
            boolean isNegated = booleanExpressionPredicate.isNegated();
            if (isNegated) {
                this.appendSql("not(");
            }
            booleanExpressionPredicate.getExpression().accept(this);
            if (isNegated) {
                this.appendSql(')');
            }
        } else {
            super.visitBooleanExpressionPredicate(booleanExpressionPredicate);
        }
    }

    @Override
    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    @Override
    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List<CaseSimpleExpression.WhenFragment> whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = whenFragments.get(0).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    @Override
    protected String getForUpdate() {
        return " with lock";
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.getDialect().getVersion().isSameOrAfter(3) && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitSelectClause(SelectClause selectClause) {
        Stack<Clause> clauseStack = this.getClauseStack();
        clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            this.visitSqlSelections(selectClause);
            this.renderVirtualSelections(selectClause);
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void visitSqlSelections(SelectClause selectClause) {
        if (!this.supportsOffsetFetchClause()) {
            this.renderFirstSkipClause((QuerySpec)this.getQueryPartStack().getCurrent());
        }
        if (selectClause.isDistinct()) {
            this.appendSql("distinct ");
        }
        super.visitSqlSelections(selectClause);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (this.supportsOffsetFetchClause() && !this.isRowNumberingCurrentQueryPart()) {
            this.renderOffsetFetchClause(queryPart, true);
        }
    }

    @Override
    protected boolean supportsSimpleQueryGrouping() {
        return this.getDialect().getVersion().isSameOrAfter(5);
    }

    @Override
    protected void renderSelectExpression(Expression expression) {
        this.renderSelectExpressionWithCastedOrInlinedPlainParameters(expression);
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS!");
            }
            expression.accept(this);
        }
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        List<Expression> listExpressions = inListPredicate.getListExpressions();
        if (listExpressions.isEmpty()) {
            this.appendSql("1=" + (inListPredicate.isNegated() ? "1" : "0"));
            return;
        }
        Expression testExpression = inListPredicate.getTestExpression();
        if (this.isParameter(testExpression)) {
            this.renderCasted(testExpression);
            if (inListPredicate.isNegated()) {
                this.appendSql(" not");
            }
            this.appendSql(" in (");
            this.renderCommaSeparated(listExpressions);
            this.appendSql(')');
        } else {
            super.visitInListPredicate(inListPredicate);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    private boolean supportsOffsetFetchClause() {
        return this.getDialect().getVersion().isSameOrAfter(3);
    }

    @Override
    protected boolean supportsIntersect() {
        return false;
    }

    @Override
    protected boolean supportsNestedWithClause() {
        return false;
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        boolean inFunction = this.inFunction;
        this.inFunction = true;
        try {
            super.visitSelfRenderingPredicate(selfRenderingPredicate);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        boolean inFunction = this.inFunction;
        this.inFunction = !(expression instanceof FunctionExpression) || !"cast".equals(((FunctionExpression)((Object)expression)).getFunctionName());
        try {
            super.visitSelfRenderingExpression(expression);
        }
        finally {
            this.inFunction = inFunction;
        }
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        if (this.inFunction) {
            this.inFunction = false;
            try {
                this.renderCasted(jdbcParameter);
            }
            finally {
                this.inFunction = true;
            }
        } else {
            super.visitParameter(jdbcParameter);
        }
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral<?> jdbcLiteral) {
        this.visitLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral<?> queryLiteral) {
        this.visitLiteral(queryLiteral);
    }

    private void visitLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            this.renderLiteral(literal, this.inFunction);
        }
    }
}

