/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.community.dialect.SingleStoreDialect;
import org.hibernate.dialect.DialectDelegateWrapper;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.MySQLSqlAstTranslator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.SetOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.Any;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CastTarget;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Every;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.QueryPartTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SingleStoreSqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private final SingleStoreDialect dialect = (SingleStoreDialect)DialectDelegateWrapper.extractRealDialect(super.getDialect());

    public SingleStoreSqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        if (this.isIntegerDivisionEmulationRequired(arithmeticExpression)) {
            this.appendSql('(');
            this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
            this.appendSql(" div ");
            this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
            this.appendSql(')');
        } else {
            super.visitBinaryArithmeticExpression(arithmeticExpression);
        }
    }

    @Override
    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    @Override
    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    @Override
    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    @Override
    protected void visitInsertSource(InsertSelectStatement statement) {
        if (statement.getSourceSelectStatement() != null) {
            if (statement.getConflictClause() != null) {
                List<ColumnReference> targetColumnReferences = statement.getTargetColumns();
                ArrayList<String> columnNames = new ArrayList<String>(targetColumnReferences.size());
                for (ColumnReference targetColumnReference : targetColumnReferences) {
                    columnNames.add(targetColumnReference.getColumnExpression());
                }
                this.appendSql("select * from ");
                this.emulateQueryPartTableReferenceColumnAliasing(new QueryPartTableReference(new SelectStatement(statement.getSourceSelectStatement()), "excluded", columnNames, false, this.getSessionFactory()));
            } else {
                statement.getSourceSelectStatement().accept(this);
            }
        } else {
            this.visitValuesList(statement.getValuesList());
        }
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        Statement currentStatement;
        if ("excluded".equals(columnReference.getQualifier()) && (currentStatement = this.getStatementStack().getCurrent()) instanceof InsertSelectStatement && ((InsertSelectStatement)currentStatement).getSourceSelectStatement() == null) {
            this.appendSql("values(");
            columnReference.appendReadExpression(this, null);
            this.append(')');
        } else {
            super.visitColumnReference(columnReference);
        }
    }

    @Override
    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack<Clause> clauseStack = this.getClauseStack();
        try {
            clauseStack.push(Clause.DELETE);
            this.renderTableReferenceIdentificationVariable(statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    @Override
    protected void renderUpdateClause(UpdateStatement updateStatement) {
        if (updateStatement.getFromClause().getRoots().isEmpty()) {
            super.renderUpdateClause(updateStatement);
        } else {
            this.appendSql("update ");
            this.renderFromClauseSpaces(updateStatement.getFromClause());
        }
    }

    @Override
    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable(tableReference);
        }
    }

    @Override
    protected boolean supportsJoinsInDelete() {
        return true;
    }

    @Override
    protected void visitConflictClause(ConflictClause conflictClause) {
        this.visitOnDuplicateKeyConflictClause(conflictClause);
    }

    @Override
    protected String determineColumnReferenceQualifier(ColumnReference columnReference) {
        String dmlAlias;
        MutationStatement currentDmlStatement;
        DmlTargetColumnQualifierSupport qualifierSupport = this.getDialect().getDmlTargetColumnQualifierSupport();
        if (this.getClauseStack().getCurrent() != Clause.SET || !((currentDmlStatement = this.getCurrentDmlStatement()) instanceof InsertSelectStatement) || (dmlAlias = currentDmlStatement.getTargetTable().getIdentificationVariable()) == null || !dmlAlias.equals(columnReference.getQualifier())) {
            return columnReference.getQualifier();
        }
        if (qualifierSupport != DmlTargetColumnQualifierSupport.NONE || !this.getQueryPartStack().isEmpty()) {
            return this.getCurrentDmlStatement().getTargetTable().getTableExpression();
        }
        return null;
    }

    @Override
    protected boolean supportsWithClauseInSubquery() {
        return false;
    }

    @Override
    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept(this);
    }

    @Override
    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        boolean isNegated = booleanExpressionPredicate.isNegated();
        if (isNegated) {
            this.appendSql("not(");
        }
        booleanExpressionPredicate.getExpression().accept(this);
        if (isNegated) {
            this.appendSql(')');
        }
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && this.supportsWindowFunctions() && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    @Override
    protected boolean shouldEmulateLateralWithIntersect(QueryPart queryPart) {
        return this.supportsSimpleQueryGrouping() || !queryPart.hasOffsetOrFetchClause();
    }

    @Override
    protected String getForUpdate() {
        return this.dialect.getForUpdateString();
    }

    @Override
    public void visitAny(Any any) {
        throw new UnsupportedOperationException("SingleStore doesn't support ANY clause");
    }

    @Override
    public void visitEvery(Every every) {
        throw new UnsupportedOperationException("SingleStore doesn't support ALL clause");
    }

    @Override
    protected boolean supportsNestedSubqueryCorrelation() {
        return false;
    }

    @Override
    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause(queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions(queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause(querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions(querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    @Override
    public void visitQueryPartTableReference(QueryPartTableReference tableReference) {
        this.emulateQueryPartTableReferenceColumnAliasing(tableReference);
    }

    @Override
    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderCombinedLimitClause(queryPart);
        }
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (operator == ComparisonOperator.DISTINCT_FROM || operator == ComparisonOperator.NOT_DISTINCT_FROM) {
            this.renderDistinct(lhs, operator, rhs);
        } else {
            lhs.accept(this);
            this.appendSql(operator.sqlText());
            rhs.accept(this);
        }
    }

    private void renderDistinct(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.appendSql('(');
        this.appendSql("case when ");
        rhs.accept(this);
        this.appendSql(" is null then ");
        if (operator == ComparisonOperator.DISTINCT_FROM) {
            this.appendSql('(');
            lhs.accept(this);
            this.appendSql(" is not null) else (");
            lhs.accept(this);
            this.appendSql("!=");
            rhs.accept(this);
            this.appendSql(" or ");
            lhs.accept(this);
            this.appendSql(" is null) end)");
        } else {
            this.appendSql('(');
            lhs.accept(this);
            this.appendSql(" is null) else (");
            lhs.accept(this);
            this.appendSql("=");
            rhs.accept(this);
            this.appendSql(") end)");
        }
    }

    @Override
    protected void emulateTupleComparison(List<? extends SqlAstNode> lhsExpressions, List<? extends SqlAstNode> rhsExpressions, ComparisonOperator operator, boolean indexOptimized) {
        if (operator == ComparisonOperator.DISTINCT_FROM || operator == ComparisonOperator.NOT_DISTINCT_FROM) {
            int size = lhsExpressions.size();
            assert (size == rhsExpressions.size());
            String separator = "(";
            for (int i = 0; i < size; ++i) {
                this.appendSql(separator);
                this.renderDistinct((Expression)lhsExpressions.get(i), operator, (Expression)rhsExpressions.get(i));
                separator = ") and (";
            }
            this.appendSql(')');
        } else {
            super.emulateTupleComparison(lhsExpressions, rhsExpressions, operator, indexOptimized);
        }
    }

    @Override
    protected void renderCombinedLimitClause(Expression offsetExpression, Expression fetchExpression) {
        if (!(offsetExpression == null && fetchExpression == null || !(this.getCurrentQueryPart() instanceof QueryGroup) || ((QueryGroup)this.getCurrentQueryPart()).getSetOperator() != SetOperator.UNION && ((QueryGroup)this.getCurrentQueryPart()).getSetOperator() != SetOperator.UNION_ALL)) {
            throw new UnsupportedOperationException("SingleStore doesn't support UNION/UNION ALL with limit clause");
        }
        super.renderCombinedLimitClause(offsetExpression, fetchExpression);
    }

    @Override
    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0'");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept(this);
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        this.appendSql("cast( ");
        likePredicate.getMatchExpression().accept(this);
        this.appendSql(" as char) ");
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        this.renderBackslashEscapedLikePattern(likePredicate.getPattern(), likePredicate.getEscapeCharacter(), false);
    }

    @Override
    protected void renderBackslashEscapedLikePattern(Expression pattern, Expression escapeCharacter, boolean noBackslashEscapes) {
        if (escapeCharacter != null) {
            this.appendSql("replace");
            this.appendSql('(');
            pattern.accept(this);
            this.appendSql(",");
            escapeCharacter.accept(this);
            this.appendSql(",'\\\\'");
            this.appendSql(')');
        } else if (pattern instanceof Literal) {
            Object literalValue = ((Literal)pattern).getLiteralValue();
            if (literalValue == null) {
                pattern.accept(this);
            } else {
                this.appendBackslashEscapedLikeLiteral(this, literalValue.toString(), false);
            }
        } else {
            this.appendSql("replace");
            this.appendSql('(');
            pattern.accept(this);
            this.appendSql(",'\\\\','\\\\\\\\'");
            this.appendSql(')');
        }
    }

    @Override
    public boolean supportsRowValueConstructorSyntaxInSet() {
        return false;
    }

    @Override
    protected boolean supportsDistinctFromPredicate() {
        return false;
    }

    @Override
    public SingleStoreDialect getDialect() {
        return this.dialect;
    }

    private boolean supportsWindowFunctions() {
        return true;
    }

    @Override
    public void visitCastTarget(CastTarget castTarget) {
        String sqlType = MySQLSqlAstTranslator.getSqlType(castTarget, this.getSessionFactory());
        if (sqlType != null) {
            this.appendSql(sqlType);
        } else {
            super.visitCastTarget(castTarget);
        }
    }
}

