/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.transaction.backend.jdbc.internal;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.internal.log.ConnectionAccessLogger;
import org.hibernate.internal.util.ExceptionHelper;
import org.hibernate.resource.transaction.spi.DdlTransactionIsolator;
import org.hibernate.tool.schema.internal.exec.JdbcContext;

public class DdlTransactionIsolatorNonJtaImpl
implements DdlTransactionIsolator {
    private final JdbcContext jdbcContext;
    private Connection jdbcConnection;
    private boolean unsetAutoCommit;

    public DdlTransactionIsolatorNonJtaImpl(JdbcContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    @Override
    public JdbcContext getJdbcContext() {
        return this.jdbcContext;
    }

    @Override
    public Connection getIsolatedConnection() {
        return this.getIsolatedConnection(true);
    }

    @Override
    public Connection getIsolatedConnection(boolean autocommit) {
        block8: {
            if (this.jdbcConnection == null) {
                try {
                    this.jdbcConnection = this.jdbcContext.getJdbcConnectionAccess().obtainConnection();
                    try {
                        if (this.jdbcConnection.getAutoCommit() == autocommit) break block8;
                        try {
                            if (autocommit) {
                                ConnectionAccessLogger.INSTANCE.informConnectionLocalTransactionForNonJtaDdl(this.jdbcContext.getJdbcConnectionAccess());
                                this.jdbcConnection.commit();
                            }
                            this.jdbcConnection.setAutoCommit(autocommit);
                            this.unsetAutoCommit = true;
                        }
                        catch (SQLException e) {
                            throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to set JDBC Connection auto-commit mode in preparation for DDL execution");
                        }
                    }
                    catch (SQLException e) {
                        throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to check JDBC Connection auto-commit in preparation for DDL execution");
                    }
                }
                catch (SQLException e) {
                    throw this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to open JDBC Connection for DDL execution");
                }
            }
        }
        return this.jdbcConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.jdbcConnection != null) {
            Throwable originalException = null;
            try {
                if (this.unsetAutoCommit) {
                    try {
                        this.jdbcConnection.setAutoCommit(!this.jdbcConnection.getAutoCommit());
                    }
                    catch (SQLException e) {
                        originalException = this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to unset auto-commit mode for JDBC Connection used for DDL execution");
                    }
                    catch (Throwable t1) {
                        originalException = t1;
                    }
                }
            }
            finally {
                Throwable suppressed = null;
                try {
                    this.jdbcContext.getJdbcConnectionAccess().releaseConnection(this.jdbcConnection);
                }
                catch (SQLException e) {
                    suppressed = this.jdbcContext.getSqlExceptionHelper().convert(e, "Unable to release JDBC Connection used for DDL execution");
                }
                catch (Throwable t2) {
                    suppressed = t2;
                }
                this.jdbcConnection = null;
                if (suppressed != null) {
                    if (originalException == null) {
                        originalException = suppressed;
                    } else {
                        originalException.addSuppressed(suppressed);
                    }
                }
            }
            if (originalException != null) {
                ExceptionHelper.doThrow(originalException);
            }
        }
    }
}

