/*
 * Decompiled with CFR 0.152.
 */
package platform.files;

import com.BlockDynasty.yaml.snakeyaml.DumperOptions;
import com.BlockDynasty.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;

public class Configuration {
    private Map<String, Object> config;
    private final String databasePath = "/database";
    private final String templatePath = "config-template.yaml";
    private final String configName = "config.yaml";
    private final String logsPath = "/logs";
    private final File configFile;
    private final File rootDirectory;

    public Configuration(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        this.configFile = new File(rootDirectory, "config.yaml");
        File databaseDir = new File(rootDirectory, "/database");
        if (!databaseDir.exists()) {
            databaseDir.mkdirs();
        }
        if (!this.configFile.exists()) {
            this.createNewConfigFile();
        } else {
            this.loadConfig();
        }
    }

    private void createNewConfigFile() {
        try {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("config-template.yaml");){
                if (inputStream == null) {
                    throw new IOException("Template resource not found: config-template.yaml");
                }
                Files.copy(inputStream, this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.loadConfig();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create config file", e);
        }
    }

    private void loadConfig() {
        try {
            Yaml yaml = new Yaml();
            this.config = (Map)yaml.load(Files.newInputStream(this.configFile.toPath(), new OpenOption[0]));
            if (this.config == null) {
                this.config = new HashMap<String, Object>();
            }
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("config-template.yaml");){
                if (inputStream == null) {
                    throw new IOException("Template resource not found: config-template.yaml");
                }
                Map defaultConfig = (Map)yaml.load(inputStream);
                if (defaultConfig != null && this.checkIfNeedUpdate(defaultConfig, this.config)) {
                    this.mergeConfigs(defaultConfig, this.config);
                    DumperOptions options = new DumperOptions();
                    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                    options.setProcessComments(true);
                    options.setPrettyFlow(true);
                    options.setIndent(2);
                    Yaml yamlWriter = new Yaml(options);
                    String yamlString = yamlWriter.dump(this.config);
                    Files.write(this.configFile.toPath(), yamlString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load config: " + e.getMessage(), e);
        }
    }

    public boolean checkIfNeedUpdate(Map<String, Object> defaultConfig, Map<String, Object> config) {
        for (Map.Entry<String, Object> entry : defaultConfig.entrySet()) {
            String key = entry.getKey();
            Object defaultValue = entry.getValue();
            if (!config.containsKey(key)) {
                return true;
            }
            if (!(defaultValue instanceof Map) || !(config.get(key) instanceof Map)) continue;
            return this.checkIfNeedUpdate((Map)defaultValue, (Map)config.get(key));
        }
        return false;
    }

    public void mergeConfigs(Map<String, Object> defaultConfig, Map<String, Object> config) {
        for (Map.Entry<String, Object> entry : defaultConfig.entrySet()) {
            String key = entry.getKey();
            Object defaultValue = entry.getValue();
            if (!config.containsKey(key)) {
                config.put(key, defaultValue);
                continue;
            }
            Object currentValue = config.get(key);
            if (!(defaultValue instanceof Map) || !(currentValue instanceof Map)) continue;
            this.mergeConfigs((Map)defaultValue, (Map)currentValue);
        }
    }

    public <T> T get(String path, Class<T> type) {
        String[] parts = path.split("\\.");
        Map current = this.config;
        for (int i = 0; i < parts.length - 1; ++i) {
            if (!current.containsKey(parts[i])) {
                return null;
            }
            current = (Map)current.get(parts[i]);
        }
        String lastPart = parts[parts.length - 1];
        if (!current.containsKey(lastPart)) {
            return null;
        }
        Object value = current.get(lastPart);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        return null;
    }

    public boolean getBoolean(String path) {
        Boolean value = this.get(path, Boolean.class);
        return value != null && value != false;
    }

    public String getString(String path) {
        return this.get(path, String.class);
    }

    public int getInt(String path) {
        Integer value = this.get(path, Integer.class);
        return value != null ? value : 0;
    }

    public double getDouble(String path) {
        Double value = this.get(path, Double.class);
        return value != null ? value : 0.0;
    }

    public String getDatabasePath() {
        return this.rootDirectory.getAbsolutePath() + "/database";
    }

    public String getLogsPath() {
        return this.rootDirectory.getAbsolutePath() + "/logs";
    }
}

