/*
 * Decompiled with CFR 0.152.
 */
package redis;

import BlockDynasty.Economy.domain.services.courier.Courier;
import com.BlockDynasty.gson.Gson;
import com.BlockDynasty.redis.clients.jedis.DefaultJedisClientConfig;
import com.BlockDynasty.redis.clients.jedis.HostAndPort;
import com.BlockDynasty.redis.clients.jedis.JedisClientConfig;
import com.BlockDynasty.redis.clients.jedis.UnifiedJedis;
import java.util.HashMap;
import java.util.UUID;
import lib.abstractions.IPlayer;
import lib.abstractions.PlatformAdapter;
import redis.RedisData;
import utils.Console;

public class Publisher
implements Courier {
    private final Gson gson = new Gson();
    private final String channelName;
    private final PlatformAdapter platformAdapter;
    private final HostAndPort hostAndPort;
    private final JedisClientConfig config;
    private final String INSTANCE_ID;

    public Publisher(RedisData redisData, PlatformAdapter platformAdapter) {
        this.channelName = redisData.getChannelName();
        this.platformAdapter = platformAdapter;
        this.hostAndPort = new HostAndPort(redisData.getHost(), redisData.getPort());
        this.config = DefaultJedisClientConfig.builder().user(redisData.getUsername()).password(redisData.getPassword()).build();
        this.INSTANCE_ID = redisData.getInstanceID();
    }

    @Override
    public void sendUpdateMessage(String type, String target) {
        this.sendUpdateMessage(type, null, target);
    }

    @Override
    public void sendUpdateMessage(String type, String data, String target) {
        if (this.shouldSkipProcessing(type, target)) {
            return;
        }
        try (UnifiedJedis jedis = new UnifiedJedis(this.hostAndPort, this.config);){
            HashMap<String, String> messageData = new HashMap<String, String>();
            messageData.put("type", type);
            messageData.put("target", target);
            messageData.put("instanceId", this.INSTANCE_ID);
            if (data != null) {
                messageData.put("data", data);
            }
            String jsonMessage = this.gson.toJson(messageData);
            jedis.publish(this.channelName, jsonMessage);
        }
        catch (Exception e) {
            Console.logError("Redis publish error: " + e.getMessage());
        }
    }

    private boolean shouldSkipProcessing(String type, String target) {
        switch (type) {
            case "account": 
            case "event": {
                IPlayer player = this.platformAdapter.getPlayerByUUID(UUID.fromString(target));
                return player != null && player.isOnline();
            }
        }
        return false;
    }
}

