/*
 * Decompiled with CFR 0.152.
 */
package repository.ConnectionHandler.Hibernate;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.h2.tools.Server;
import repository.ConnectionHandler.Hibernate.ConnectionHibernate;
import utils.Console;

public class ConnectionHibernateSQLite
extends ConnectionHibernate {
    private Server webServer;

    public ConnectionHibernateSQLite(String dbFilePath, boolean enableServerConsole) {
        this.configuration.setProperty("hibernate.connection.driver_class", "org.sqlite.JDBC");
        this.configuration.setProperty("hibernate.connection.url", "jdbc:sqlite:" + dbFilePath + "/database.db");
        this.configuration.setProperty("hibernate.dialect", "org.hibernate.community.dialect.SQLiteDialect");
        this.init();
        if (enableServerConsole) {
            this.startServerConsole(dbFilePath);
        }
    }

    private void startServerConsole(String dbFilePath) {
        try {
            System.setProperty("h2.consoleForcePassword", "false");
            System.setProperty("h2.bindAddress", "localhost");
            System.setProperty("h2.webAllowOthers", "true");
            System.setProperty("h2.webAdminPassword", "");
            this.webServer = Server.createWebServer((String[])new String[]{"-web", "-webAllowOthers", "-webPort", "8082", "-baseDir", dbFilePath});
            this.webServer.start();
            String jdbcUrl = "jdbc:h2:file:" + dbFilePath + "/h2Database";
            String consoleUrl = "http://localhost:8082/";
            String directAccessUrl = consoleUrl + "login.jsp?jsessionid=autocomplete&url=" + URLEncoder.encode(jdbcUrl, StandardCharsets.UTF_8) + "&user=sa&password=";
            Console.log("  -> SQL WEB console started at: " + consoleUrl);
            Console.log("  -> Direct access URL: " + directAccessUrl);
            Console.log("  -> JDBC URL: " + jdbcUrl);
        }
        catch (Exception e) {
            Console.logError("Failed to start H2 console: " + e.getMessage());
        }
    }

    @Override
    protected void stopServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }
}

