/*
 * Decompiled with CFR 0.152.
 */
package repository.Models;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import repository.Models.AccountDb;
import repository.Models.BalanceDb;

@Entity
@Table(name="wallet")
public class WalletDb {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @OneToMany(mappedBy="wallet", cascade={CascadeType.ALL})
    private List<AccountDb> accounts = new ArrayList<AccountDb>();
    @OneToMany(mappedBy="wallet", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<BalanceDb> balances = new ArrayList<BalanceDb>();

    public void addBalance(BalanceDb balance) {
        this.balances.add(balance);
        balance.setWallet(this);
    }

    public void removeBalance(BalanceDb balance) {
        this.balances.remove(balance);
        balance.setWallet(null);
    }

    public void setAccount(AccountDb account) {
        this.accounts.add(account);
        account.setWallet(this);
    }

    public void removeAccount(AccountDb account) {
        this.accounts.remove(account);
        account.setWallet(null);
    }

    public List<AccountDb> getAccounts() {
        return this.accounts;
    }

    public Long getId() {
        return this.id;
    }

    public List<BalanceDb> getBalances() {
        return this.balances;
    }

    public void setBalances(List<BalanceDb> balances) {
        this.balances = balances;
    }
}

