/*
 * Decompiled with CFR 0.152.
 */
package services;

import java.util.Map;
import lib.abstractions.IMessages;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import platform.files.Languages;

public class Message
implements IMessages {
    private static final String color = ChatColor.stringValueOf(Colors.GRAY);
    private static String prefix;
    private static Languages lang;

    public static void addLang(Languages lang) {
        Message.lang = lang;
        String rawPrefix = lang.getMessage("prefix");
        prefix = rawPrefix.replace("{color}", ChatColor.stringValueOf(Colors.GREEN));
    }

    public static String process(Map<String, String> placeholders, String messageKey) {
        String processedMessage = lang.getMessage(messageKey);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            processedMessage = processedMessage.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        processedMessage = processedMessage.replace("{prefix}", prefix);
        processedMessage = processedMessage.replace("{color}", color);
        return processedMessage;
    }

    @Override
    public String format(Map<String, String> placeholders, String messageKey) {
        return Message.process(placeholders, messageKey);
    }

    @Override
    public String format(String messageKey) {
        return lang.getMessage(messageKey);
    }

    @Override
    public String[] formatLines(Map<String, String> placeholders, String messageKey) {
        String processedMessage = Message.process(placeholders, messageKey);
        return processedMessage.split(",");
    }

    @Override
    public String[] formatLines(String messageKey) {
        String processedMessage = lang.getMessage(messageKey);
        return processedMessage.split(",");
    }
}

