/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation;

import BlockDynasty.BukkitImplementation.Integrations.Placeholder.PlaceHolder;
import BlockDynasty.BukkitImplementation.Integrations.vault.Vault;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.textInput.TextInputFactory;
import BlockDynasty.BukkitImplementation.adapters.GUI.listener.ClickListener;
import BlockDynasty.BukkitImplementation.adapters.GUI.listener.CloseListener;
import BlockDynasty.BukkitImplementation.adapters.commands.CommandRegister;
import BlockDynasty.BukkitImplementation.adapters.listeners.PlayerJoinListenerOffline;
import BlockDynasty.BukkitImplementation.adapters.listeners.PlayerJoinListenerOnline;
import BlockDynasty.BukkitImplementation.adapters.platformAdapter.BukkitAdapter;
import BlockDynasty.BukkitImplementation.adapters.proxy.ChannelRegister;
import BlockDynasty.BukkitImplementation.utils.Console;
import BlockDynasty.BukkitImplementation.utils.Updater;
import BlockDynasty.BukkitImplementation.utils.Version;
import Main.Economy;
import com.BlockDynasty.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import platform.files.Configuration;

public class BlockDynastyEconomy
extends JavaPlugin {
    private static BlockDynastyEconomy instance;
    private Economy economy;
    private static Configuration configuration;
    private Metrics metrics;

    public void onLoad() {
    }

    public void onEnable() {
        if (Version.isUnsupportedVersion()) {
            this.getLogger().severe("Unsupported Minecraft version detected: " + Bukkit.getBukkitVersion());
            this.getLogger().severe("Disabling plugin to prevent issues.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        instance = this;
        try {
            this.initCoreServices();
            this.registerCommands();
            this.registerEvents();
            this.setupIntegrations();
            Console.log("\u00a7aPlugin enabled successfully!");
        }
        catch (Exception e) {
            this.getLogger().severe("An error occurred during plugin initialization: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        try {
            this.metrics = new Metrics((Plugin)this, 27470);
            Updater.check(this, 129308);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisable() {
        Economy.shutdown();
        Vault.unhook();
        PlaceHolder.unregister();
        ChannelRegister.unhook(this);
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    private void initCoreServices() {
        this.economy = Economy.init(TextInputFactory.getTextInput(), new BukkitAdapter());
        configuration = this.economy.getConfiguration();
    }

    private void registerCommands() {
        CommandRegister.registerAll();
    }

    private void registerEvents() {
        PlayerJoinListenerOnline economyListener = new PlayerJoinListenerOnline(this.economy.getPlayerJoinListener());
        if (configuration.getBoolean("online")) {
            if (!this.getServer().getOnlineMode()) {
                Console.logError("THE SERVER IS IN OFFLINE MODE but the plugin is configured to work in ONLINE mode, please change the configuration to avoid issues.");
            }
            economyListener = new PlayerJoinListenerOnline(this.economy.getPlayerJoinListener());
            Console.log("Online mode is enabled. The plugin will use UUID to identify players.");
        }
        if (!configuration.getBoolean("online")) {
            if (this.getServer().getOnlineMode()) {
                Console.logError("THE SERVER IS IN ONLINE MODE but the plugin is configured to work in OFFLINE mode, please change the configuration to avoid issues.");
            }
            economyListener = new PlayerJoinListenerOffline(this.economy.getPlayerJoinListener());
            Console.log("Online mode is disabled, The plugin will use NICKNAME to identify players.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)economyListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CloseListener(), (Plugin)this);
    }

    private void setupIntegrations() {
        Vault.init(this.economy.getApiWithLog(this.economy.getVaultLogger()));
        PlaceHolder.register(this.economy.getPlaceHolder());
        ChannelRegister.init(this);
    }

    public static BlockDynastyEconomy getInstance() {
        return instance;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

