/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.account;

import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import java.util.List;
import java.util.UUID;

public class SearchAccountUseCase {
    private final IAccountService accountService;
    private final IRepository dataStore;

    public SearchAccountUseCase(IAccountService accountService, IRepository dataStore) {
        this.accountService = accountService;
        this.dataStore = dataStore;
    }

    public Result<List<Account>> getOfflineAccounts() {
        List<Account> accounts = this.accountService.getAccountsOffline();
        if (accounts.isEmpty()) {
            return Result.failure("No accounts found", ErrorCode.ACCOUNT_NOT_FOUND);
        }
        return Result.success(accounts);
    }

    public Result<Account> getAccount(String name) {
        Account account = this.accountService.getAccount(name);
        if (account != null) {
            return Result.success(account);
        }
        return Result.failure("Account not found", ErrorCode.ACCOUNT_NOT_FOUND);
    }

    public Result<Account> getAccount(UUID uuid) {
        Account account = this.accountService.getAccount(uuid);
        if (account != null) {
            return Result.success(account);
        }
        return Result.failure("Account not found", ErrorCode.ACCOUNT_NOT_FOUND);
    }

    public Result<List<Account>> getTopAccounts(String currency, int limit, int offset) {
        List<Account> accounts;
        if (limit <= 0) {
            return Result.failure("Limit must be greater than 0", ErrorCode.INVALID_ARGUMENT);
        }
        List<Account> cache = this.accountService.getAccountsTopList(currency);
        if (!cache.isEmpty() && cache.size() >= limit + offset) {
            return Result.success(cache.subList(offset, Math.min(offset + limit, cache.size())));
        }
        if (!this.dataStore.isTopSupported()) {
            return Result.failure("Repository not support top", ErrorCode.REPOSITORY_NOT_SUPPORT_TOP);
        }
        try {
            accounts = this.dataStore.getAccountsTopByCurrency(currency, limit, offset);
            for (Account account : accounts) {
                this.accountService.addAccountToTopList(account, currency);
            }
        }
        catch (TransactionException e) {
            return Result.failure("Error in transaction", ErrorCode.DATA_BASE_ERROR);
        }
        if (accounts.isEmpty()) {
            return Result.failure("No accounts found for currency: " + currency, ErrorCode.ACCOUNT_NOT_FOUND);
        }
        return Result.success(accounts);
    }
}

