/*
 * Decompiled with CFR 0.152.
 */
package lib.gui;

import BlockDynasty.Economy.aplication.useCase.AccountsUseCase;
import BlockDynasty.Economy.aplication.useCase.CurrencyUseCase;
import BlockDynasty.Economy.aplication.useCase.OfferUseCase;
import BlockDynasty.Economy.aplication.useCase.TransactionsUseCase;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import java.util.UUID;
import lib.abstractions.PlatformAdapter;
import lib.gui.GUIService;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IGUIService;
import lib.gui.components.ITextInput;
import lib.gui.components.abstractions.AbstractPanel;
import lib.gui.templates.administrators.mainMenus.AccountSelectorToEdit;
import lib.gui.templates.administrators.mainMenus.CurrencyAdminPanel;
import lib.gui.templates.administrators.mainMenus.EconomyAdminPanel;
import lib.gui.templates.administrators.subMenus.accounts.DepositPanel;
import lib.gui.templates.administrators.subMenus.accounts.EditAccountPanel;
import lib.gui.templates.administrators.subMenus.accounts.SetBalancePanel;
import lib.gui.templates.administrators.subMenus.accounts.WithdrawPanel;
import lib.gui.templates.administrators.subMenus.currencies.ColorSelectionPanel;
import lib.gui.templates.administrators.subMenus.currencies.CreateCurrencyGUI;
import lib.gui.templates.administrators.subMenus.currencies.CurrencyListDelete;
import lib.gui.templates.administrators.subMenus.currencies.CurrencyListEdit;
import lib.gui.templates.administrators.subMenus.currencies.EditCurrencyPanel;
import lib.gui.templates.users.AccountBalance;
import lib.gui.templates.users.BankPanel;
import lib.gui.templates.users.CurrencyListToPay;
import lib.gui.templates.users.Exchange.ExchangeFirstPanel;
import lib.gui.templates.users.ListPlayersFromDb;
import lib.gui.templates.users.ListPlayersOnline;
import lib.gui.templates.users.Offers.CreateOfferFirstPanel;
import lib.gui.templates.users.Offers.MyActiveOffers;
import lib.gui.templates.users.Offers.ReceivedOffers;

public class GUIFactory {
    private static CurrencyUseCase currencyUseCase;
    private static AccountsUseCase accountsUseCase;
    private static TransactionsUseCase transactionsUseCase;
    private static OfferUseCase offerUseCase;
    private static ITextInput textInput;
    private static final IGUIService guiService;

    public static void init(CurrencyUseCase currencyUseCase, AccountsUseCase accountsUseCase, TransactionsUseCase transactionsUseCase, OfferUseCase offerUseCase, ITextInput textInput, PlatformAdapter adapter) {
        AbstractPanel.setPlatformAdapter(adapter, guiService);
        GUIFactory.currencyUseCase = currencyUseCase;
        GUIFactory.accountsUseCase = accountsUseCase;
        GUIFactory.transactionsUseCase = transactionsUseCase;
        GUIFactory.offerUseCase = offerUseCase;
        GUIFactory.textInput = textInput;
    }

    public static IGUIService getGuiService() {
        return guiService;
    }

    public static IGUI economyAdminPanel(IEntityGUI sender) {
        return new EconomyAdminPanel(sender);
    }

    public static IGUI accountSelectorToEdit(IEntityGUI sender, IGUI parent) {
        return new AccountSelectorToEdit(sender, accountsUseCase.getGetAccountsUseCase(), parent, textInput);
    }

    public static IGUI editAccountPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new EditAccountPanel(accountsUseCase.getDeleteAccountUseCase(), accountsUseCase.getEditAccountUseCase(), accountsUseCase.getGetAccountsUseCase(), sender, target, parent, textInput);
    }

    public static IGUI balancePanel(IEntityGUI sender, UUID target, IGUI parent) {
        return new AccountBalance(sender, target, accountsUseCase.getGetBalanceUseCase(), parent);
    }

    public static IGUI depositPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new DepositPanel(sender, target, currencyUseCase.getGetCurrencyUseCase(), transactionsUseCase.getDepositUseCase(), parent, textInput);
    }

    public static IGUI setPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new SetBalancePanel(sender, target, currencyUseCase.getGetCurrencyUseCase(), transactionsUseCase.getSetBalanceUseCase(), parent, textInput);
    }

    public static IGUI withdrawPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new WithdrawPanel(sender, target, currencyUseCase.getGetCurrencyUseCase(), transactionsUseCase.getWithdrawUseCase(), parent, textInput);
    }

    public static IGUI currencyPanel(IEntityGUI player, IGUI parent) {
        return new CurrencyAdminPanel(player, parent);
    }

    public static void createCurrencyPanel(IEntityGUI sender, IGUI parent) {
        new CreateCurrencyGUI(sender, currencyUseCase.getCreateCurrencyUseCase(), currencyUseCase.getGetCurrencyUseCase(), parent, textInput);
    }

    public static IGUI currencyListToDeletePanel(IEntityGUI player, IGUI parent) {
        return new CurrencyListDelete(player, currencyUseCase.getGetCurrencyUseCase(), currencyUseCase.getDeleteCurrencyUseCase(), parent, textInput);
    }

    public static IGUI currencyListToEditPanel(IEntityGUI player, IGUI parent) {
        return new CurrencyListEdit(player, currencyUseCase.getGetCurrencyUseCase(), parent, textInput);
    }

    public static IGUI editCurrencyPanel(IEntityGUI sender, Currency currency, IGUI parent) {
        return new EditCurrencyPanel(sender, currency, currencyUseCase.getEditCurrencyUseCase(), parent, textInput);
    }

    public static IGUI colorSelectorPanel(IEntityGUI sender, Currency currency, EditCurrencyPanel parent) {
        return new ColorSelectionPanel(sender, currency, currencyUseCase.getEditCurrencyUseCase(), parent, textInput);
    }

    public static IGUI bankPanel(IEntityGUI sender) {
        return new BankPanel(sender, accountsUseCase.getGetAccountsUseCase(), textInput);
    }

    public static IGUI createOfferFirstPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new CreateOfferFirstPanel(sender, target, currencyUseCase.getGetCurrencyUseCase(), offerUseCase.getCreateOfferUseCase(), parent, textInput);
    }

    public static IGUI balancePanel(IEntityGUI sender, IGUI parent) {
        return new AccountBalance(sender, accountsUseCase.getGetBalanceUseCase(), parent);
    }

    public static IGUI listPlayersFromDb(IEntityGUI sender, IGUI parent) {
        return new ListPlayersFromDb(sender, parent, accountsUseCase.getGetAccountsUseCase(), textInput);
    }

    public static IGUI exchangeFirstPanel(IEntityGUI sender, IGUI parent) {
        return new ExchangeFirstPanel(sender, currencyUseCase.getGetCurrencyUseCase(), transactionsUseCase.getExchangeUseCase(), parent, textInput);
    }

    public static IGUI receivedOffers(IEntityGUI sender, IGUI parent) {
        return new ReceivedOffers(offerUseCase.getSearchOfferUseCase(), offerUseCase.getAcceptOfferUseCase(), offerUseCase.getCancelOfferUseCase(), sender, parent);
    }

    public static IGUI myActiveOffers(IEntityGUI sender, IGUI parent) {
        return new MyActiveOffers(offerUseCase.getSearchOfferUseCase(), offerUseCase.getCancelOfferUseCase(), sender, parent);
    }

    public static IGUI myActiveOffers(IEntityGUI sender) {
        return new MyActiveOffers(offerUseCase.getSearchOfferUseCase(), offerUseCase.getCancelOfferUseCase(), sender, null);
    }

    public static IGUI listPlayersOnline(IEntityGUI sender, IGUI parent) {
        return new ListPlayersOnline(sender, parent, textInput);
    }

    public static IGUI currencyListToPayPanel(IEntityGUI sender, Player target, IGUI parent) {
        return new CurrencyListToPay(sender, target, currencyUseCase.getGetCurrencyUseCase(), transactionsUseCase.getPayUseCase(), parent, textInput);
    }

    static {
        guiService = new GUIService();
    }
}

