/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.administrators.subMenus.currencies;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.IItemStack;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;

public class ColorSelectionPanel
extends AbstractPanel {
    private final IEntityGUI player;
    private final Currency currency;
    private final EditCurrencyUseCase editCurrencyUseCase;
    private final ITextInput textInput;

    public ColorSelectionPanel(IEntityGUI player, Currency currency, EditCurrencyUseCase editCurrencyUseCase, IGUI parent, ITextInput textInput) {
        super("Select color", 5, player, parent);
        this.player = player;
        this.currency = currency;
        this.editCurrencyUseCase = editCurrencyUseCase;
        this.textInput = textInput;
        this.setupColorGUI();
    }

    private void setupColorGUI() {
        this.setItem(4, this.createItem(Materials.PAPER, "List Vanilla Colors", "These colors ensure maximum compatibility between versions", "Additionally you can enter Hexadecimal color for modern versions"), null);
        this.setItem(10, this.createColorItem(Materials.WHITE_WOOL, ChatColor.stringValueOf("WHITE"), "WHITE"), unused -> this.handleColorSelection("WHITE"));
        this.setItem(11, this.createColorItem(Materials.YELLOW_WOOL, ChatColor.stringValueOf("YELLOW"), "YELLOW"), unused -> this.handleColorSelection("YELLOW"));
        this.setItem(12, this.createColorItem(Materials.RED_WOOL, ChatColor.stringValueOf("RED"), "RED"), unused -> this.handleColorSelection("RED"));
        this.setItem(13, this.createColorItem(Materials.PINK_WOOL, ChatColor.stringValueOf("LIGHT_PURPLE"), "LIGHT_PURPLE"), unused -> this.handleColorSelection("LIGHT_PURPLE"));
        this.setItem(14, this.createColorItem(Materials.PURPLE_WOOL, ChatColor.stringValueOf("DARK_PURPLE"), "DARK_PURPLE"), unused -> this.handleColorSelection("DARK_PURPLE"));
        this.setItem(15, this.createColorItem(Materials.ORANGE_WOOL, ChatColor.stringValueOf("GOLD"), "GOLD"), unused -> this.handleColorSelection("GOLD"));
        this.setItem(16, this.createColorItem(Materials.LIME_WOOL, ChatColor.stringValueOf("GREEN"), "GREEN"), unused -> this.handleColorSelection("GREEN"));
        this.setItem(19, this.createColorItem(Materials.GRAY_WOOL, ChatColor.stringValueOf("GRAY"), "GRAY"), unused -> this.handleColorSelection("GRAY"));
        this.setItem(20, this.createColorItem(Materials.LIGHT_GRAY_WOOL, ChatColor.stringValueOf("DARK_GRAY"), "DARK_GRAY"), unused -> this.handleColorSelection("DARK_GRAY"));
        this.setItem(21, this.createColorItem(Materials.CYAN_WOOL, ChatColor.stringValueOf("AQUA"), "AQUA"), unused -> this.handleColorSelection("AQUA"));
        this.setItem(22, this.createColorItem(Materials.LIGHT_BLUE_WOOL, ChatColor.stringValueOf("BLUE"), "BLUE"), unused -> this.handleColorSelection("BLUE"));
        this.setItem(23, this.createColorItem(Materials.BLUE_WOOL, ChatColor.stringValueOf("DARK_BLUE"), "DARK_BLUE"), unused -> this.handleColorSelection("DARK_BLUE"));
        this.setItem(24, this.createColorItem(Materials.BROWN_WOOL, ChatColor.stringValueOf("DARK_RED"), "DARK_RED"), unused -> this.handleColorSelection("DARK_RED"));
        this.setItem(25, this.createColorItem(Materials.GREEN_WOOL, ChatColor.stringValueOf("DARK_GREEN"), "DARK_GREEN"), unused -> this.handleColorSelection("DARK_GREEN"));
        this.setItem(32, this.createColorItem(Materials.GRAY_WOOL, ChatColor.stringValueOf("BLACK"), "BLACK"), unused -> this.handleColorSelection("BLACK"));
        this.setItem(30, this.createColorItem(Materials.CYAN_WOOL, ChatColor.stringValueOf("DARK_AQUA"), "DARK_AQUA"), unused -> this.handleColorSelection("DARK_AQUA"));
        this.setItem(39, this.createItem(Materials.NAME_TAG, "Input color Hex (#..)", new String[0]), unused -> this.textInput.open(this, this.player, "Hexadecimal Color", "#", s -> {
            try {
                this.editCurrencyUseCase.editColor(this.currency.getSingular(), (String)s);
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Color updated successfully to " + s + ".");
                GUIFactory.editCurrencyPanel(this.player, this.currency, this.getParent().getParent()).open();
            }
            catch (Exception e) {
                this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank]" + ChatColor.stringValueOf(Colors.RED) + " Error: " + ChatColor.stringValueOf(Colors.YELLOW) + e.getMessage());
                this.openParent();
            }
            return null;
        }));
        this.setItem(40, this.createItem(Materials.BARRIER, ChatColor.stringValueOf(Colors.RED) + "Back", ChatColor.stringValueOf(Colors.GRAY) + "Click to go back"), unused -> this.openParent());
    }

    private void handleColorSelection(String colorName) {
        try {
            this.editCurrencyUseCase.editColor(this.currency.getSingular(), colorName);
            this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.GRAY) + "Color updated successfully to " + colorName + ".");
            GUIFactory.editCurrencyPanel(this.player, this.currency, this.getParent().getParent()).open();
        }
        catch (Exception e) {
            this.player.sendMessage(ChatColor.stringValueOf(Colors.GREEN) + "[Bank] " + ChatColor.stringValueOf(Colors.RED) + "Error: " + ChatColor.stringValueOf(Colors.YELLOW) + e.getMessage());
            this.openParent();
        }
    }

    private IItemStack createColorItem(Materials material, String chatColor, String colorName) {
        return this.createItem(material, chatColor + colorName, ChatColor.stringValueOf(Colors.GRAY) + "Click to select this color.", chatColor + "Example: " + this.currency.getSingular());
    }
}

