/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class SqmPolymorphicRootDescriptor<T>
implements EntityDomainType<T> {
    private final Set<EntityDomainType<? extends T>> implementors;
    private final Map<String, PersistentAttribute<? super T, ?>> commonAttributes;
    private final JavaType<T> polymorphicJavaType;

    public SqmPolymorphicRootDescriptor(JavaType<T> polymorphicJavaType, Set<EntityDomainType<? extends T>> implementors) {
        this.polymorphicJavaType = polymorphicJavaType;
        TreeSet<EntityDomainType> treeSet = new TreeSet<EntityDomainType>(Comparator.comparing(ManagedDomainType::getTypeName));
        treeSet.addAll(implementors);
        this.implementors = treeSet;
        this.commonAttributes = Collections.unmodifiableMap(this.inferCommonAttributes(implementors));
    }

    private Map<String, PersistentAttribute<? super T, ?>> inferCommonAttributes(Set<EntityDomainType<? extends T>> implementors) {
        HashMap workMap = new HashMap();
        ArrayList<EntityDomainType<T>> implementorsList = new ArrayList<EntityDomainType<T>>(implementors);
        EntityDomainType<T> firstImplementor = implementorsList.get(0);
        if (implementorsList.size() == 1) {
            firstImplementor.visitAttributes((? super PersistentAttribute<? super J, ?> attribute) -> workMap.put(attribute.getName(), this.promote((PersistentAttribute<?, ?>)attribute)));
        } else {
            List<EntityDomainType<? extends T>> subList = implementorsList.subList(1, implementors.size() - 1);
            firstImplementor.visitAttributes((? super PersistentAttribute<? super J, ?> attribute) -> {
                if (SqmPolymorphicRootDescriptor.isACommonAttribute(subList, attribute)) {
                    workMap.put(attribute.getName(), this.promote((PersistentAttribute<?, ?>)attribute));
                }
            });
        }
        return workMap;
    }

    private PersistentAttribute<? super T, ?> promote(PersistentAttribute<?, ?> attribute) {
        return attribute;
    }

    private static boolean isACommonAttribute(List<EntityDomainType<?>> subList, PersistentAttribute<?, ?> attribute) {
        for (EntityDomainType<?> navigable : subList) {
            if (navigable.findAttribute(attribute.getName()) != null) continue;
            return false;
        }
        return true;
    }

    public Set<EntityDomainType<? extends T>> getImplementors() {
        return this.implementors;
    }

    @Override
    public String getName() {
        return this.polymorphicJavaType.getTypeName();
    }

    @Override
    public String getHibernateEntityName() {
        return this.getName();
    }

    @Override
    public String getTypeName() {
        return this.getName();
    }

    @Override
    public String getPathName() {
        return this.getName();
    }

    @Override
    public DomainType<T> getSqmPathType() {
        return this;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.ENTITY_TYPE;
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.polymorphicJavaType.getJavaTypeClass();
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.ENTITY;
    }

    @Override
    public Class<T> getJavaType() {
        return this.getBindableJavaType();
    }

    @Override
    public JavaType<T> getExpressibleJavaType() {
        return this.polymorphicJavaType;
    }

    @Override
    public PersistentAttribute<? super T, ?> findAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public PersistentAttribute<?, ?> findSubTypesAttribute(String name) {
        return this.commonAttributes.get(name);
    }

    @Override
    public PersistentAttribute<? super T, ?> findAttributeInSuperTypes(String name) {
        return null;
    }

    @Override
    public void visitAttributes(Consumer<? super PersistentAttribute<? super T, ?>> action) {
        this.commonAttributes.values().forEach(action);
    }

    @Override
    public void visitDeclaredAttributes(Consumer<? super PersistentAttribute<T, ?>> action) {
    }

    @Override
    public PersistentAttribute<? super T, ?> getAttribute(String name) {
        PersistentAttribute<T, ?> attribute = this.findAttribute(name);
        if (attribute == null) {
            throw new IllegalArgumentException();
        }
        return attribute;
    }

    @Override
    public PersistentAttribute<T, ?> getDeclaredAttribute(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findSingularAttribute(String name) {
        return (SingularPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public PluralPersistentAttribute<? super T, ?, ?> findPluralAttribute(String name) {
        return (PluralPersistentAttribute)this.findAttribute(name);
    }

    @Override
    public PersistentAttribute<? super T, ?> findConcreteGenericAttribute(String name) {
        return null;
    }

    @Override
    public PersistentAttribute<T, ?> findDeclaredAttribute(String name) {
        return null;
    }

    @Override
    public SingularPersistentAttribute<T, ?> findDeclaredSingularAttribute(String name) {
        return null;
    }

    @Override
    public PluralPersistentAttribute<T, ?, ?> findDeclaredPluralAttribute(String name) {
        return null;
    }

    @Override
    public PersistentAttribute<T, ?> findDeclaredConcreteGenericAttribute(String name) {
        return null;
    }

    @Override
    public Set<Attribute<? super T, ?>> getAttributes() {
        return new HashSet(this.commonAttributes.values());
    }

    @Override
    public Set<Attribute<T, ?>> getDeclaredAttributes() {
        return Collections.emptySet();
    }

    @Override
    public <Y> SingularAttribute<? super T, Y> getSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)this.getAttribute(name);
    }

    @Override
    public <Y> SingularAttribute<T, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        return (SingularAttribute)this.getDeclaredAttribute(name);
    }

    @Override
    public Set<SingularAttribute<? super T, ?>> getSingularAttributes() {
        HashSet singularAttributes = new HashSet();
        for (PersistentAttribute<? super T, ?> persistentAttribute : this.commonAttributes.values()) {
            if (!(persistentAttribute instanceof SingularAttribute)) continue;
            singularAttributes.add((SingularPersistentAttribute)persistentAttribute);
        }
        return singularAttributes;
    }

    @Override
    public Set<SingularAttribute<T, ?>> getDeclaredSingularAttributes() {
        return Collections.emptySet();
    }

    @Override
    public <E> CollectionAttribute<? super T, E> getCollection(String name, Class<E> elementType) {
        return (CollectionAttribute)this.getAttribute(name);
    }

    @Override
    public <E> CollectionAttribute<T, E> getDeclaredCollection(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <E> SetAttribute<? super T, E> getSet(String name, Class<E> elementType) {
        return (SetAttribute)this.getAttribute(name);
    }

    @Override
    public <E> SetAttribute<T, E> getDeclaredSet(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <E> ListAttribute<? super T, E> getList(String name, Class<E> elementType) {
        return (ListAttribute)this.getAttribute(name);
    }

    @Override
    public <E> ListAttribute<T, E> getDeclaredList(String name, Class<E> elementType) {
        throw new IllegalArgumentException();
    }

    @Override
    public <K, V> MapAttribute<? super T, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        return (MapAttribute)this.getAttribute(name);
    }

    @Override
    public <K, V> MapAttribute<T, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        throw new IllegalArgumentException();
    }

    @Override
    public Set<PluralAttribute<? super T, ?, ?>> getPluralAttributes() {
        HashSet pluralAttributes = new HashSet();
        for (PersistentAttribute<? super T, ?> persistentAttribute : this.commonAttributes.values()) {
            if (!(persistentAttribute instanceof PluralAttribute)) continue;
            pluralAttributes.add((PluralPersistentAttribute)persistentAttribute);
        }
        return pluralAttributes;
    }

    @Override
    public Set<PluralAttribute<T, ?, ?>> getDeclaredPluralAttributes() {
        return Collections.emptySet();
    }

    @Override
    public SingularAttribute<? super T, ?> getSingularAttribute(String name) {
        return (SingularPersistentAttribute)this.getAttribute(name);
    }

    @Override
    public SingularAttribute<T, ?> getDeclaredSingularAttribute(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public CollectionAttribute<? super T, ?> getCollection(String name) {
        return (CollectionAttribute)this.getAttribute(name);
    }

    @Override
    public CollectionAttribute<T, ?> getDeclaredCollection(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SetAttribute<? super T, ?> getSet(String name) {
        return (SetAttribute)this.getAttribute(name);
    }

    @Override
    public SetAttribute<T, ?> getDeclaredSet(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public ListAttribute<? super T, ?> getList(String name) {
        return (ListAttribute)this.getAttribute(name);
    }

    @Override
    public ListAttribute<T, ?> getDeclaredList(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public MapAttribute<? super T, ?, ?> getMap(String name) {
        return (MapAttribute)this.getAttribute(name);
    }

    @Override
    public MapAttribute<T, ?, ?> getDeclaredMap(String name) {
        throw new IllegalArgumentException();
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        return (SqmPathSource)((Object)this.findAttribute(name));
    }

    @Override
    public SqmPath<T> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepresentationMode getRepresentationMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public SqmPathSource<?> getIdentifierDescriptor() {
        return null;
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredId(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<? super T, Y> getVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <Y> SingularPersistentAttribute<T, Y> getDeclaredVersion(Class<Y> type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<SingularAttribute<? super T, ?>> getIdClassAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SimpleDomainType<?> getIdType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IdentifiableDomainType<? super T> getSupertype() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasIdClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findIdAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitIdClassAttributes(Consumer<SingularPersistentAttribute<? super T, ?>> action) {
    }

    @Override
    public SingularPersistentAttribute<? super T, ?> findVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends SingularPersistentAttribute<? super T, ?>> findNaturalIdAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasSingleIdAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasVersionAttribute() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ManagedDomainType<? super T> getSuperType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends EntityDomainType<? extends T>> getSubTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSubType(ManagedDomainType<? extends T> subType) {
        throw new UnsupportedOperationException();
    }
}

