/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.insert;

import jakarta.persistence.criteria.Path;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaConflictClause;
import org.hibernate.query.criteria.JpaConflictUpdateAction;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmVisitableNode;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmConflictUpdateAction;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;

public class SqmConflictClause<T>
implements SqmVisitableNode,
JpaConflictClause<T> {
    private final SqmInsertStatement<T> insertStatement;
    private final SqmRoot<T> excludedRoot;
    private @Nullable String constraintName;
    private List<SqmPath<?>> constraintPaths;
    private @Nullable SqmConflictUpdateAction<T> updateAction;

    public SqmConflictClause(SqmInsertStatement<T> insertStatement) {
        this.insertStatement = insertStatement;
        this.excludedRoot = new SqmRoot(((SqmRoot)insertStatement.getTarget()).getManagedType(), "excluded", false, insertStatement.nodeBuilder());
    }

    private SqmConflictClause(SqmInsertStatement<T> insertStatement, SqmRoot<T> excludedRoot, @Nullable String constraintName, List<SqmPath<?>> constraintPaths, @Nullable SqmConflictUpdateAction<T> updateAction) {
        this.insertStatement = insertStatement;
        this.excludedRoot = excludedRoot;
        this.constraintName = constraintName;
        this.constraintPaths = Collections.unmodifiableList(constraintPaths);
        this.updateAction = updateAction;
    }

    @Override
    public SqmRoot<T> getExcludedRoot() {
        return this.excludedRoot;
    }

    @Override
    public @Nullable String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public SqmConflictClause<T> conflictOnConstraint(@Nullable String constraintName) {
        if (this.constraintPaths != null && !this.constraintPaths.isEmpty()) {
            throw new IllegalStateException("Constraint paths were already set: " + this.constraintPaths);
        }
        this.constraintName = constraintName;
        return this;
    }

    @Override
    public JpaConflictClause<T> conflictOnConstraintAttributes(String ... attributes) {
        ArrayList<JpaPath> paths = new ArrayList<JpaPath>(attributes.length);
        for (String attribute : attributes) {
            paths.add(((AbstractSqmPath)((Object)this.insertStatement.getTarget())).get(attribute));
        }
        return this.conflictOnConstraintPaths(paths);
    }

    @Override
    public JpaConflictClause<T> conflictOnConstraintAttributes(SingularAttribute<T, ?> ... attributes) {
        ArrayList<JpaPath> paths = new ArrayList<JpaPath>(attributes.length);
        for (SingularAttribute<T, ?> attribute : attributes) {
            paths.add(((AbstractSqmPath)((Object)this.insertStatement.getTarget())).get(attribute));
        }
        return this.conflictOnConstraintPaths(paths);
    }

    @Override
    public SqmConflictClause<T> conflictOnConstraintPaths(Path<?> ... paths) {
        return this.conflictOnConstraintPaths(Arrays.asList(paths));
    }

    @Override
    public SqmConflictClause<T> conflictOnConstraintPaths(List<? extends Path<?>> paths) {
        if (this.constraintName != null) {
            throw new IllegalStateException("Constraint name was already set: " + this.constraintName);
        }
        this.constraintPaths = Collections.unmodifiableList(paths);
        return this;
    }

    @Override
    public List<SqmPath<?>> getConstraintPaths() {
        return this.constraintPaths == null ? Collections.emptyList() : this.constraintPaths;
    }

    @Override
    public SqmConflictUpdateAction<T> createConflictUpdateAction() {
        return new SqmConflictUpdateAction<T>(this.insertStatement);
    }

    @Override
    public @Nullable SqmConflictUpdateAction<T> getConflictAction() {
        return this.updateAction;
    }

    @Override
    public JpaConflictClause<T> onConflictDo(JpaConflictUpdateAction<T> action) {
        this.updateAction = (SqmConflictUpdateAction)action;
        return this;
    }

    @Override
    public SqmConflictUpdateAction<T> onConflictDoUpdate() {
        JpaConflictUpdateAction conflictUpdateAction = this.createConflictUpdateAction();
        this.onConflictDo(conflictUpdateAction);
        return conflictUpdateAction;
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.insertStatement.nodeBuilder();
    }

    @Override
    public SqmConflictClause<T> copy(SqmCopyContext context) {
        SqmConflictClause existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        return context.registerCopy(this, new SqmConflictClause<T>(this.insertStatement.copy(context), this.excludedRoot.copy(context), this.constraintName, this.copyOf(this.constraintPaths, context), this.updateAction == null ? null : this.updateAction.copy(context)));
    }

    private List<SqmPath<?>> copyOf(List<SqmPath<?>> constraintPaths, SqmCopyContext context) {
        if (constraintPaths.isEmpty()) {
            return constraintPaths;
        }
        ArrayList copies = new ArrayList(constraintPaths.size());
        for (SqmPath<?> constraintPath : constraintPaths) {
            copies.add((SqmPath<?>)constraintPath.copy(context));
        }
        return copies;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitConflictClause(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append(" on conflict");
        if (this.constraintName != null) {
            sb.append(" on constraint ");
            sb.append(this.constraintName);
        } else if (!this.constraintPaths.isEmpty()) {
            int separator = 40;
            for (SqmPath<?> path : this.constraintPaths) {
                sb.append((char)separator);
                SqmConflictClause.appendUnqualifiedPath(sb, path);
                separator = 44;
            }
            sb.append(')');
        }
        if (this.updateAction == null) {
            sb.append(" do nothing");
        } else {
            this.updateAction.appendHqlString(sb);
        }
    }

    private static void appendUnqualifiedPath(StringBuilder sb, SqmPath<?> path) {
        if (path.getLhs() == null) {
            return;
        }
        SqmConflictClause.appendUnqualifiedPath(sb, path.getLhs());
        if (path.getLhs().getLhs() != null) {
            sb.append('.');
        }
        sb.append(path.getReferencedPathSource().getPathName());
    }
}

