/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.NoopLimitHandler;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.spi.EventManager;
import org.hibernate.event.spi.HibernateMonitoringEvent;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.query.spi.Limit;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.resource.jdbc.spi.JdbcSessionContext;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcLockStrategy;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;

public class DeferredResultSetAccess
extends AbstractResultSetAccess {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(DeferredResultSetAccess.class);
    private final JdbcOperationQuerySelect jdbcSelect;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final ExecutionContext executionContext;
    private final JdbcSelectExecutor.StatementCreator statementCreator;
    private final SqlStatementLogger sqlStatementLogger;
    private final String finalSql;
    private final Limit limit;
    private final LimitHandler limitHandler;
    private final boolean usesFollowOnLocking;
    private final int resultCountEstimate;
    private PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DeferredResultSetAccess(JdbcOperationQuerySelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, JdbcSelectExecutor.StatementCreator statementCreator, int resultCountEstimate) {
        super(executionContext.getSession());
        this.jdbcParameterBindings = jdbcParameterBindings;
        this.executionContext = executionContext;
        this.jdbcSelect = jdbcSelect;
        this.statementCreator = statementCreator;
        this.sqlStatementLogger = executionContext.getSession().getJdbcServices().getSqlStatementLogger();
        this.resultCountEstimate = resultCountEstimate;
        QueryOptions queryOptions = executionContext.getQueryOptions();
        if (queryOptions == null) {
            this.finalSql = jdbcSelect.getSqlString();
            this.limit = null;
            this.limitHandler = NoopLimitHandler.NO_LIMIT;
            this.usesFollowOnLocking = false;
        } else {
            String sql;
            Dialect dialect = executionContext.getSession().getJdbcServices().getDialect();
            this.limit = queryOptions.getLimit();
            if (this.limit == null || this.limit.isEmpty() || jdbcSelect.usesLimitParameters()) {
                sql = jdbcSelect.getSqlString();
                this.limitHandler = NoopLimitHandler.NO_LIMIT;
            } else {
                this.limitHandler = dialect.getLimitHandler();
                sql = this.limitHandler.processSql(jdbcSelect.getSqlString(), this.limit, queryOptions);
            }
            LockOptions lockOptions = queryOptions.getLockOptions();
            JdbcLockStrategy jdbcLockStrategy = jdbcSelect.getLockStrategy();
            if (jdbcLockStrategy != JdbcLockStrategy.NONE && lockOptions != null && !lockOptions.isEmpty()) {
                this.usesFollowOnLocking = DeferredResultSetAccess.useFollowOnLocking(jdbcLockStrategy, sql, queryOptions, lockOptions, dialect);
                if (this.usesFollowOnLocking) {
                    LockMode lockMode = this.determineFollowOnLockMode(lockOptions);
                    if (lockMode != LockMode.UPGRADE_SKIPLOCKED) {
                        if (lockOptions.getLockMode() != LockMode.NONE) {
                            LOG.usingFollowOnLocking();
                        }
                        LockOptions lockOptionsToUse = new LockOptions(lockMode);
                        lockOptionsToUse.setTimeOut(lockOptions.getTimeOut());
                        lockOptionsToUse.setScope(lockOptions.getScope());
                        executionContext.getCallback().registerAfterLoadAction((entity, persister, session) -> session.asSessionImplementor().lock(persister.getEntityName(), entity, lockOptionsToUse));
                    }
                } else {
                    sql = dialect.applyLocksToSql(sql, lockOptions, Collections.emptyMap());
                }
            } else {
                this.usesFollowOnLocking = false;
            }
            this.finalSql = dialect.addSqlHintOrComment(sql, queryOptions, executionContext.getSession().getFactory().getSessionFactoryOptions().isCommentsEnabled());
        }
    }

    private static boolean useFollowOnLocking(JdbcLockStrategy jdbcLockStrategy, String sql, QueryOptions queryOptions, LockOptions lockOptions, Dialect dialect) {
        switch (jdbcLockStrategy) {
            case FOLLOW_ON: {
                return true;
            }
            case AUTO: {
                return lockOptions.getFollowOnLocking() == null ? dialect.useFollowOnLocking(sql, queryOptions) : lockOptions.getFollowOnLocking().booleanValue();
            }
        }
        return false;
    }

    public LimitHandler getLimitHandler() {
        return this.limitHandler;
    }

    public Limit getLimit() {
        return this.limit;
    }

    @Override
    public ResultSet getResultSet() {
        if (this.resultSet == null) {
            this.executeQuery();
        }
        return this.resultSet;
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.executionContext.getSession().getFactory();
    }

    public String getFinalSql() {
        return this.finalSql;
    }

    public boolean usesFollowOnLocking() {
        return this.usesFollowOnLocking;
    }

    protected void bindParameters(PreparedStatement preparedStatement) throws SQLException {
        QueryOptions queryOptions = this.executionContext.getQueryOptions();
        if (queryOptions != null) {
            if (queryOptions.getFetchSize() != null) {
                preparedStatement.setFetchSize(queryOptions.getFetchSize());
            }
            if (queryOptions.getTimeout() != null) {
                preparedStatement.setQueryTimeout(queryOptions.getTimeout());
            }
        }
        int paramBindingPosition = 1;
        paramBindingPosition += this.limitHandler.bindLimitParametersAtStartOfQuery(this.limit, preparedStatement, paramBindingPosition);
        for (JdbcParameterBinder parameterBinder : this.jdbcSelect.getParameterBinders()) {
            parameterBinder.bindParameterValue(preparedStatement, paramBindingPosition++, this.jdbcParameterBindings, this.executionContext);
        }
        paramBindingPosition += this.limitHandler.bindLimitParametersAtEndOfQuery(this.limit, preparedStatement, paramBindingPosition);
        if (!this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getMaxRows() != null) {
            this.limitHandler.setMaxRows(this.limit, preparedStatement);
        } else {
            int maxRows = this.jdbcSelect.getMaxRows();
            if (maxRows != Integer.MAX_VALUE) {
                preparedStatement.setMaxRows(maxRows);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeQuery() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        SharedSessionContractImplementor session = this.executionContext.getSession();
        try {
            LOG.tracef("Executing query to retrieve ResultSet : %s", (Object)this.finalSql);
            this.preparedStatement = this.statementCreator.createStatement(this.executionContext, this.finalSql);
            this.bindParameters(this.preparedStatement);
            SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
            long executeStartNanos = 0L;
            if (this.sqlStatementLogger.getLogSlowQuery() > 0L) {
                executeStartNanos = System.nanoTime();
            }
            EventManager eventManager = session.getEventManager();
            HibernateMonitoringEvent jdbcPreparedStatementExecutionEvent = eventManager.beginJdbcPreparedStatementExecutionEvent();
            try {
                eventListenerManager.jdbcExecuteStatementStart();
                this.resultSet = this.wrapResultSet(this.preparedStatement.executeQuery());
            }
            finally {
                eventManager.completeJdbcPreparedStatementExecutionEvent(jdbcPreparedStatementExecutionEvent, this.finalSql);
                eventListenerManager.jdbcExecuteStatementEnd();
                this.sqlStatementLogger.logSlowQuery(this.finalSql, executeStartNanos, this.context());
            }
            this.skipRows(this.resultSet);
            logicalConnection.getResourceRegistry().register(this.resultSet, this.preparedStatement);
        }
        catch (SQLException e) {
            try {
                this.release();
            }
            catch (RuntimeException e2) {
                e.addSuppressed(e2);
            }
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "JDBC exception executing SQL [" + this.finalSql + "]");
        }
    }

    private JdbcSessionContext context() {
        return this.executionContext.getSession().getJdbcCoordinator().getJdbcSessionOwner().getJdbcSessionContext();
    }

    protected void skipRows(ResultSet resultSet) throws SQLException {
        int rowsToSkip = !this.jdbcSelect.usesLimitParameters() && this.limit != null && this.limit.getFirstRow() != null && !this.limitHandler.supportsLimitOffset() ? this.limit.getFirstRow().intValue() : this.jdbcSelect.getRowsToSkip();
        if (rowsToSkip != 0) {
            try {
                resultSet.absolute(rowsToSkip);
            }
            catch (SQLException ex) {
                try {
                    resultSet.next();
                }
                catch (SQLException ex2) {
                    throw ex;
                }
                for (int i = 1; i < rowsToSkip && resultSet.next(); ++i) {
                }
            }
        }
    }

    protected ResultSet wrapResultSet(ResultSet resultSet) throws SQLException {
        return resultSet;
    }

    protected LockMode determineFollowOnLockMode(LockOptions lockOptions) {
        LockMode lockModeToUse = lockOptions.findGreatestLockMode();
        if (lockOptions.hasAliasSpecificLockModes()) {
            if (lockOptions.getLockMode() == LockMode.NONE && lockModeToUse == LockMode.NONE) {
                return lockModeToUse;
            }
            LOG.aliasSpecificLockingWithFollowOnLocking(lockModeToUse);
        }
        return lockModeToUse;
    }

    @Override
    public void release() {
        LogicalConnectionImplementor logicalConnection = this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection();
        if (this.resultSet != null) {
            logicalConnection.getResourceRegistry().release(this.resultSet, this.preparedStatement);
            this.resultSet = null;
        }
        if (this.preparedStatement != null) {
            logicalConnection.getResourceRegistry().release(this.preparedStatement);
            this.preparedStatement = null;
        }
        logicalConnection.afterStatement();
    }

    @Override
    public int getResultCountEstimate() {
        if (this.limit != null && this.limit.getMaxRows() != null) {
            return this.limit.getMaxRows();
        }
        if (this.jdbcSelect.getLimitParameter() != null) {
            return (Integer)this.jdbcParameterBindings.getBinding(this.jdbcSelect.getLimitParameter()).getBindValue();
        }
        if (this.resultCountEstimate > 0) {
            return this.resultCountEstimate;
        }
        return super.getResultCountEstimate();
    }
}

