/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.script;

import com.BlockDynasty.antlr.v4.runtime.BailErrorStrategy;
import com.BlockDynasty.antlr.v4.runtime.BaseErrorListener;
import com.BlockDynasty.antlr.v4.runtime.CharStreams;
import com.BlockDynasty.antlr.v4.runtime.CommonTokenStream;
import com.BlockDynasty.antlr.v4.runtime.ConsoleErrorListener;
import com.BlockDynasty.antlr.v4.runtime.DefaultErrorStrategy;
import com.BlockDynasty.antlr.v4.runtime.RecognitionException;
import com.BlockDynasty.antlr.v4.runtime.Recognizer;
import com.BlockDynasty.antlr.v4.runtime.atn.ParserATNSimulator;
import com.BlockDynasty.antlr.v4.runtime.atn.PredictionMode;
import com.BlockDynasty.antlr.v4.runtime.misc.ParseCancellationException;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.grammars.importsql.SqlScriptLexer;
import org.hibernate.grammars.importsql.SqlScriptParser;
import org.hibernate.tool.schema.internal.script.SqlScriptVisitor;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.SqlScriptException;

public class MultiLineSqlScriptExtractor
implements SqlScriptCommandExtractor {
    public static final String SHORT_NAME = "multi-line";
    public static final MultiLineSqlScriptExtractor INSTANCE = new MultiLineSqlScriptExtractor();

    @Override
    public List<String> extractCommands(Reader reader, Dialect dialect) {
        try {
            SqlScriptParser.ScriptContext scriptParseTree = MultiLineSqlScriptExtractor.buildScriptParseTree(reader);
            SqlScriptVisitor visitor = new SqlScriptVisitor(dialect);
            return visitor.visitScript(scriptParseTree);
        }
        catch (Exception e) {
            if (e instanceof SqlScriptException) {
                throw (SqlScriptException)e;
            }
            throw new SqlScriptException("Error during sql-script parsing.", e);
        }
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(Reader reader) throws IOException {
        SqlScriptLexer lexer = new SqlScriptLexer(CharStreams.fromReader(reader));
        return MultiLineSqlScriptExtractor.buildScriptParseTree(lexer);
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(SqlScriptLexer lexer) {
        return MultiLineSqlScriptExtractor.buildScriptParseTree(lexer, new SqlScriptParser(new CommonTokenStream(lexer)));
    }

    private static SqlScriptParser.ScriptContext buildScriptParseTree(SqlScriptLexer lexer, SqlScriptParser parser) {
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.setErrorHandler(new BailErrorStrategy());
        parser.addErrorListener(new VerboseListener());
        try {
            return parser.script();
        }
        catch (ParseCancellationException e) {
            lexer.reset();
            parser.reset();
            ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
            parser.addErrorListener(ConsoleErrorListener.INSTANCE);
            parser.setErrorHandler(new DefaultErrorStrategy());
            return parser.script();
        }
    }

    public static class VerboseListener
    extends BaseErrorListener {
        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            if (msg.contains("missing ';'")) {
                throw new SqlScriptException("Import script Sql statements must terminate with a ';' char");
            }
            super.syntaxError(recognizer, offendingSymbol, line, charPositionInLine, msg, e);
        }
    }
}

