/*
 * Decompiled with CFR 0.152.
 */
package repository.ConnectionHandler.Hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import repository.ConnectionHandler.Hibernate.Connection;
import repository.Models.AccountDb;
import repository.Models.BalanceDb;
import repository.Models.CurrencyDb;
import repository.Models.WalletDb;

public abstract class ConnectionHibernate
implements Connection {
    private SessionFactory sessionFactory;
    protected Configuration configuration = new Configuration();

    public ConnectionHibernate() {
        this.configuration.setProperty("hibernate.hbm2ddl.auto", "update");
        this.configuration.setProperty("hibernate.connection.autocommit", "true");
        this.configuration.setProperty("hibernate.cache.use_second_level_cache", "false");
        this.configuration.setProperty("hibernate.show_sql", "false");
        this.configuration.setProperty("hibernate.format_sql", "false");
        this.configuration.setProperty("hibernate.use_sql_comments", "false");
        this.configuration.addAnnotatedClass(CurrencyDb.class);
        this.configuration.addAnnotatedClass(AccountDb.class);
        this.configuration.addAnnotatedClass(BalanceDb.class);
        this.configuration.addAnnotatedClass(WalletDb.class);
    }

    protected void init() {
        try {
            this.sessionFactory = this.configuration.buildSessionFactory();
        }
        catch (Throwable ex) {
            throw new ExceptionInInitializerError("Initial SessionFactory creation failed: " + String.valueOf(ex));
        }
    }

    @Override
    public SessionFactory getSession() {
        return this.sessionFactory;
    }

    @Override
    public void close() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
    }
}

