/*
 * Decompiled with CFR 0.152.
 */
package com.blockdynasty.velocity;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelMessageSource;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;

@Plugin(id="blockdynastyeconomy", name="BlockDynastyEconomy", version="1.0", authors={"federkone"})
public class Velocity {
    private static final String CHANNEL_NAME = "proxy:blockdynasty";
    @Inject
    private ProxyServer proxyServer;
    @Inject
    private Logger logger;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.proxyServer.getChannelRegistrar().register(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)CHANNEL_NAME)});
        this.logger.info("Velocity BlockDynastyEconomy Channel Registered....");
    }

    @Subscribe
    public void onShutdown(ProxyShutdownEvent event) {
        this.proxyServer.getChannelRegistrar().unregister(new ChannelIdentifier[]{MinecraftChannelIdentifier.from((String)CHANNEL_NAME)});
        this.logger.info("Velocity BlockDynastyEconomy Channel Unregistered....");
    }

    @Subscribe
    public void onPluginMessage(PluginMessageEvent event) {
        if (!event.getIdentifier().getId().equals(CHANNEL_NAME)) {
            return;
        }
        ChannelMessageSource channelMessageSource = event.getSource();
        if (channelMessageSource instanceof ServerConnection) {
            ServerConnection backend = (ServerConnection)channelMessageSource;
            String serverSourceName = backend.getServerInfo().getName();
            event.setResult(PluginMessageEvent.ForwardResult.handled());
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(event.getData()));
                String jsonMessage = dataInputStream.readUTF();
                Gson gson = new Gson();
                Map messageData = (Map)gson.fromJson(jsonMessage, new TypeToken<Map<String, String>>(){}.getType());
                String type = (String)messageData.get("type");
                if (type.equals("event") || type.equals("account")) {
                    String target = (String)messageData.get("target");
                    UUID uuid = UUID.fromString(target);
                    Optional optional = this.proxyServer.getPlayer(uuid);
                    optional.flatMap(Player::getCurrentServer).ifPresent(targetServer -> {
                        if (!targetServer.getServerInfo().getName().equals(serverSourceName)) {
                            targetServer.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)CHANNEL_NAME), event.getData());
                        }
                    });
                } else if (type.equals("currency")) {
                    this.proxyServer.getAllServers().stream().filter(targetServer -> !targetServer.getServerInfo().getName().equals(serverSourceName)).forEach(targetServer -> targetServer.sendPluginMessage((ChannelIdentifier)MinecraftChannelIdentifier.from((String)CHANNEL_NAME), event.getData()));
                }
            }
            catch (Exception e) {
                this.logger.warn("->> Error reading message: {}", (Object)e.getMessage());
            }
        }
    }
}

