/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.Integrations.vault;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.Integrations.vault.IVaultHandler;
import BlockDynasty.BukkitImplementation.Integrations.vault.VaultHook;
import BlockDynasty.BukkitImplementation.utils.Console;
import api.IApi;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;

public class VaultHandler
implements IVaultHandler {
    private VaultHook economy = null;
    private final BlockDynastyEconomy plugin;
    private final IApi api;

    public VaultHandler(BlockDynastyEconomy plugin, IApi api) {
        this.plugin = plugin;
        this.api = api;
    }

    @Override
    public void hook() {
        try {
            if (this.economy == null) {
                this.economy = new VaultHook(this.api);
            }
            ServicesManager sm = Bukkit.getServicesManager();
            sm.register(Economy.class, (Object)this.economy, (Plugin)this.plugin, ServicePriority.Highest);
            Console.log("Vault link enabled.");
        }
        catch (Exception e) {
            Console.logError(e.getMessage());
        }
    }

    @Override
    public void unhook() {
        ServicesManager sm = Bukkit.getServicesManager();
        if (this.economy != null) {
            sm.unregister(Economy.class, (Object)this.economy);
            this.economy = null;
        }
    }
}

