/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.platformAdapter;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.MaterialAdapter;
import BlockDynasty.BukkitImplementation.utils.Version;
import java.util.UUID;
import lib.abstractions.IPlayer;
import lib.commands.abstractions.IEntityCommands;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IInventory;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class EntityPlayerAdapter
implements IPlayer {
    Player player;

    private EntityPlayerAdapter(Player player) {
        this.player = player;
    }

    public static EntityPlayerAdapter of(Player player) {
        return new EntityPlayerAdapter(player);
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public boolean isOnline() {
        return this.player.isOnline();
    }

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public void sendMessage(String message) {
        if (!Version.hasSupportAdventureText() || BlockDynastyEconomy.getConfiguration().getBoolean("forceVanillaColorsSystem")) {
            message = this.translateColorCodes(message);
            this.player.sendMessage(message);
        } else {
            Component textonuevo = MiniMessage.miniMessage().deserialize((Object)message);
            this.player.sendMessage(textonuevo);
        }
    }

    private String translateColorCodes(String message) {
        return message.replaceAll("&([0-9a-fk-or])", "\u00a7$1");
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    @Override
    public void kickPlayer(String message) {
        this.player.kickPlayer(message);
    }

    @Override
    public void closeInventory() {
        this.player.closeInventory();
    }

    @Override
    public void openInventory(IInventory inventory) {
        Inventory inventoryBukkit = (Inventory)inventory.getHandle();
        this.player.openInventory(inventoryBukkit);
    }

    @Override
    public void playNotificationSound() {
        this.player.playSound(this.player.getLocation(), MaterialAdapter.getPickupSound(), 1.0f, 1.0f);
    }

    @Override
    public void playSuccessSound() {
        this.player.playSound(this.player.getLocation(), MaterialAdapter.getClickSound(), 0.3f, 1.0f);
    }

    @Override
    public void playFailureSound() {
        this.player.playSound(this.player.getLocation(), "block.note_block.pling", 0.3f, 0.5f);
    }

    @Override
    public Object getRoot() {
        return this.player;
    }

    @Override
    public IEntityGUI asEntityGUI() {
        return this;
    }

    @Override
    public IEntityCommands asEntityCommands() {
        return this;
    }
}

