/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.scheduler;

import BlockDynasty.BukkitImplementation.scheduler.SchedulerBukkit;
import BlockDynasty.BukkitImplementation.utils.Console;
import BlockDynasty.BukkitImplementation.utils.Version;
import BlockDynasty.FoliaImplementation.scheduler.SchedulerFolia;
import lib.scheduler.ContextualTask;
import lib.scheduler.IScheduler;

public class SchedulerFactory {
    private static IScheduler schedulerInstance;

    public static IScheduler getScheduler() {
        if (schedulerInstance != null) {
            return schedulerInstance;
        }
        if (Version.hasFoliaScheduler()) {
            schedulerInstance = SchedulerFolia.init();
            Console.log("Folia detected, applying Folia scheduler implementation.");
        } else {
            schedulerInstance = SchedulerBukkit.init();
            Console.log("Bukkit detected, applying Bukkit scheduler implementation.");
        }
        return schedulerInstance;
    }

    public static void run(ContextualTask contextualTask) {
        SchedulerFactory.getScheduler().run(contextualTask);
    }

    public static void runAsync(ContextualTask contextualTask) {
        SchedulerFactory.getScheduler().runAsync(contextualTask);
    }

    public static void runLater(long delay, ContextualTask contextualTask) {
        SchedulerFactory.getScheduler().runLater(delay, contextualTask);
    }
}

