/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.balance;

import BlockDynasty.Economy.domain.entities.balance.IMoney;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;

public class Money
implements IMoney {
    private Currency currency;
    private BigDecimal amount;

    public Money(Currency currency) {
        this.currency = currency;
        this.amount = currency.getDefaultBalance();
    }

    public Money(Currency currency, BigDecimal amount) {
        this.currency = currency;
        this.amount = amount;
    }

    public Money(Money money) {
        this.currency = new Currency(money.getCurrency());
        this.amount = money.getAmount();
    }

    @Override
    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    @Override
    public BigDecimal getAmount() {
        return this.amount;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public String format() {
        return this.currency.format(this.amount);
    }

    @Override
    public boolean hasEnough(BigDecimal amount) {
        return this.amount.compareTo(amount) >= 0;
    }

    @Override
    public Result<Void> setAmount(BigDecimal amount) {
        if (!this.currency.isValidAmount(amount)) {
            return Result.failure("Invalid amount for currency", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        if (amount.doubleValue() < 0.0) {
            return Result.failure("Amount must be greater than -1", ErrorCode.INVALID_AMOUNT);
        }
        this.amount = amount;
        return Result.success(null);
    }

    @Override
    public Result<Void> subtract(BigDecimal amount) {
        if (!this.currency.isValidAmount(amount)) {
            return Result.failure("Invalid amount for currency", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return Result.failure("Amount must be greater than -1", ErrorCode.INVALID_AMOUNT);
        }
        if (!this.hasEnough(amount)) {
            return Result.failure("Insufficient funds", ErrorCode.INSUFFICIENT_FUNDS);
        }
        this.amount = this.amount.subtract(amount);
        return Result.success(null);
    }

    @Override
    public Result<Void> add(BigDecimal amount) {
        if (!this.currency.isValidAmount(amount)) {
            return Result.failure("Invalid amount for currency", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return Result.failure("Amount must be greater than -1", ErrorCode.INVALID_AMOUNT);
        }
        this.amount = this.amount.add(amount);
        return Result.success(null);
    }

    public String toString() {
        return "Money{currency=" + String.valueOf(this.currency) + ", amount=" + this.amount.toString() + "}";
    }
}

