/*
 * Decompiled with CFR 0.152.
 */
package com.BlockDynasty.gson;

import com.BlockDynasty.gson.JsonElement;
import com.BlockDynasty.gson.JsonIOException;
import com.BlockDynasty.gson.internal.Streams;
import com.BlockDynasty.gson.internal.bind.JsonTreeReader;
import com.BlockDynasty.gson.internal.bind.JsonTreeWriter;
import com.BlockDynasty.gson.stream.JsonReader;
import com.BlockDynasty.gson.stream.JsonToken;
import com.BlockDynasty.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;

public abstract class TypeAdapter<T> {
    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final void toJson(Writer out, T value) throws IOException {
        JsonWriter writer = new JsonWriter(out);
        this.write(writer, value);
    }

    public final String toJson(T value) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            this.toJson(Streams.writerForAppendable(stringBuilder), value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        return stringBuilder.toString();
    }

    public final JsonElement toJsonTree(T value) {
        try {
            JsonTreeWriter jsonWriter = new JsonTreeWriter();
            this.write(jsonWriter, value);
            return jsonWriter.get();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public abstract T read(JsonReader var1) throws IOException;

    public final T fromJson(Reader in) throws IOException {
        JsonReader reader = new JsonReader(in);
        return this.read(reader);
    }

    public final T fromJson(String json) throws IOException {
        return this.fromJson(new StringReader(json));
    }

    public final T fromJsonTree(JsonElement jsonTree) {
        try {
            JsonTreeReader jsonReader = new JsonTreeReader(jsonTree);
            return this.read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public final TypeAdapter<T> nullSafe() {
        if (!(this instanceof NullSafeTypeAdapter)) {
            return new NullSafeTypeAdapter();
        }
        return this;
    }

    private final class NullSafeTypeAdapter
    extends TypeAdapter<T> {
        private NullSafeTypeAdapter() {
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                TypeAdapter.this.write(out, value);
            }
        }

        @Override
        public T read(JsonReader reader) throws IOException {
            if (reader.peek() == JsonToken.NULL) {
                reader.nextNull();
                return null;
            }
            return TypeAdapter.this.read(reader);
        }

        public String toString() {
            return "NullSafeTypeAdapter[" + TypeAdapter.this + "]";
        }
    }
}

