/*
 * Decompiled with CFR 0.152.
 */
package lib.commands.templates.administrators.EconomySubcommand.CurrencySubcommand;

import BlockDynasty.Economy.aplication.useCase.currency.EditCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import java.util.List;
import lib.commands.abstractions.AbstractCommand;
import lib.commands.abstractions.IEntityCommands;

public class EditSymbolCommand
extends AbstractCommand {
    private EditCurrencyUseCase editCurrencyUseCase;

    public EditSymbolCommand(EditCurrencyUseCase editCurrencyUseCase) {
        super("symbol", "", List.of("currency", "symbol"));
        this.editCurrencyUseCase = editCurrencyUseCase;
    }

    @Override
    public boolean execute(IEntityCommands sender, String[] args) {
        if (!super.execute(sender, args)) {
            return false;
        }
        String currencyName = args[0];
        String currencySymbol = args[1];
        try {
            this.editCurrencyUseCase.editSymbol(currencyName, currencySymbol);
            sender.sendMessage("Currency symbol for " + currencyName + " updated: " + currencySymbol);
        }
        catch (TransactionException e) {
            sender.sendMessage("error in transaction.");
        }
        catch (CurrencyNotFoundException e) {
            sender.sendMessage("Unknown currency: " + currencyName);
        }
        return true;
    }
}

