/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.result.Result;
import java.util.Map;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AbstractPanel;
import lib.gui.templates.users.Offers.ListPlayerOnlineToOffer;
import lib.gui.templates.users.Offers.ListPlayersOfflineToOffer;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public class BankPanel
extends AbstractPanel {
    private final IEntityGUI player;
    private final SearchAccountUseCase searchAccountUseCase;
    private final ITextInput textInput;

    public BankPanel(IEntityGUI player, SearchAccountUseCase SearchAccountUseCase2, ITextInput textInput) {
        super(Message.process("BankPanel.title") + " [" + player.getName() + "]", 4, player);
        this.player = player;
        this.searchAccountUseCase = SearchAccountUseCase2;
        this.textInput = textInput;
        this.setupGUI();
    }

    private void setupGUI() {
        Result<Account> account = this.searchAccountUseCase.getAccount(this.player.getUniqueId());
        boolean isBlocked = false;
        if (account.isSuccess()) {
            isBlocked = account.getValue().isBlocked();
        }
        this.setItem(4, isBlocked ? this.createItem(Materials.RED_CONCRETE, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.RED)), "BankPanel.button1.nameItem1"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button1.lore")) : this.createItem(Materials.LIME_CONCRETE, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "BankPanel.button1.nameItem2"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button1.lore")), null);
        this.setItem(11, this.createItem(Materials.DIAMOND, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button2.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button2.lore")), unused -> GUIFactory.exchangeFirstPanel(this.player, this).open());
        this.setItem(24, this.createItem(Materials.WRITABLE_BOOK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button3.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button3.lore")), f -> new ListPlayerOnlineToOffer(this.player, this, this.textInput).open());
        this.setItem(25, this.createItem(Materials.WRITABLE_BOOK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button4.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button4.lore")), f -> new ListPlayersOfflineToOffer(this.player, this, this.searchAccountUseCase, this.textInput).open());
        this.setItem(22, this.createItem(Materials.ENDER_CHEST, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button5.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button5.lore")), f -> GUIFactory.myActiveOffers(this.player, this).open());
        this.setItem(13, this.createItem(Materials.BOOK, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button6.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button6.lore")), unused -> GUIFactory.balancePanel(this.player, this).open());
        this.setItem(20, this.createItem(Materials.CHEST, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button7.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button7.lore")), f -> GUIFactory.receivedOffers(this.player, this).open());
        this.setItem(15, this.createItem(Materials.PLAYER_HEAD, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button8.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button8.lore")), unused -> GUIFactory.listPlayersOnline(this.player, this).open());
        this.setItem(16, this.createItem(Materials.PLAYER_HEAD, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GOLD)), "BankPanel.button9.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button9.lore")), f -> GUIFactory.listPlayersFromDb(this.player, this).open());
        this.setItem(31, this.createItem(Materials.BARRIER, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.RED)), "BankPanel.button10.nameItem"), Message.process(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "BankPanel.button10.lore")), unused -> this.close());
    }
}

