/*
 * Decompiled with CFR 0.152.
 */
package lib.gui.templates.users;

import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.result.Result;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lib.gui.GUIFactory;
import lib.gui.components.IEntityGUI;
import lib.gui.components.IGUI;
import lib.gui.components.ITextInput;
import lib.gui.components.Materials;
import lib.gui.components.abstractions.AccountsList;
import lib.util.colors.ChatColor;
import lib.util.colors.Colors;
import lib.util.colors.Message;

public class ListPlayersFromDb
extends AccountsList {
    private IEntityGUI sender;
    private final SearchAccountUseCase searchAccountUseCase;

    public ListPlayersFromDb(IEntityGUI sender, IGUI parent, SearchAccountUseCase searchAccountUseCase, ITextInput textInput) {
        super(Message.process("listPlayersFromDb.title"), 5, sender, parent, textInput);
        this.sender = sender;
        this.searchAccountUseCase = searchAccountUseCase;
        Result<List<Account>> result = searchAccountUseCase.getOfflineAccounts();
        if (result.isSuccess()) {
            List<Player> players = result.getValue().stream().map(Account::getPlayer).sorted((a2, b) -> a2.getNickname().compareToIgnoreCase(b.getNickname())).collect(Collectors.toList());
            this.showPlayers(players);
        } else {
            this.showPlayers(new ArrayList<Player>());
        }
    }

    @Override
    public Player findPlayerByName(String playerName) {
        Result<Account> result = this.searchAccountUseCase.getAccount(playerName);
        if (result.isSuccess()) {
            return result.getValue().getPlayer();
        }
        return null;
    }

    @Override
    public void openNextSection(Player target) {
        GUIFactory.currencyListToPayPanel(this.sender, target, this.getParent()).open();
    }

    @Override
    public void addCustomButtons() {
        super.addCustomButtons();
        this.setItem(4, this.createItem(Materials.PAPER, Message.process(Map.of("color", ChatColor.stringValueOf(Colors.GREEN)), "listPlayersFromDb.button1.nameItem"), Message.processLines(Map.of("color", ChatColor.stringValueOf(Colors.WHITE)), "listPlayersFromDb.button1.lore")), null);
    }
}

