/*
 * Decompiled with CFR 0.152.
 */
package lib.scheduler;

import lib.scheduler.IEntity;
import lib.scheduler.ILocation;

public class ContextualTask {
    private final Runnable runnable;
    private final IEntity entity;
    private final ILocation locationContext;

    private ContextualTask(Runnable runnable, IEntity entity, ILocation locationContext) {
        this.runnable = runnable;
        this.entity = entity;
        this.locationContext = locationContext;
    }

    public static ContextualTask build(Runnable runnable) {
        return new ContextualTask(runnable, null, null);
    }

    public static ContextualTask build(Runnable runnable, IEntity entity) {
        return new ContextualTask(runnable, entity, null);
    }

    public static ContextualTask build(Runnable runnable, ILocation locationContext) {
        return new ContextualTask(runnable, null, locationContext);
    }

    public static ContextualTask build(Runnable runnable, IEntity entity, ILocation locationContext) {
        return new ContextualTask(runnable, entity, locationContext);
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public IEntity getEntityContext() {
        return this.entity;
    }

    public ILocation getLocationContext() {
        return this.locationContext;
    }

    public boolean hasEntityContext() {
        return this.entity != null;
    }

    public boolean hasLocationContext() {
        return this.locationContext != null;
    }
}

