/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.archive.scan.spi;

import jakarta.persistence.Converter;
import jakarta.persistence.Embeddable;
import jakarta.persistence.Entity;
import jakarta.persistence.MappedSuperclass;
import java.io.IOException;
import java.io.InputStream;
import org.hibernate.boot.archive.scan.internal.ClassDescriptorImpl;
import org.hibernate.boot.archive.scan.internal.ScanResultCollector;
import org.hibernate.boot.archive.scan.spi.ClassDescriptor;
import org.hibernate.boot.archive.spi.ArchiveContext;
import org.hibernate.boot.archive.spi.ArchiveEntry;
import org.hibernate.boot.archive.spi.ArchiveEntryHandler;
import org.hibernate.boot.archive.spi.ArchiveException;
import org.jboss.jandex.ClassSummary;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;

public class ClassFileArchiveEntryHandler
implements ArchiveEntryHandler {
    private static final DotName CONVERTER = DotName.createSimple(Converter.class.getName());
    private static final DotName[] MODELS = new DotName[]{DotName.createSimple(Entity.class.getName()), DotName.createSimple(MappedSuperclass.class.getName()), DotName.createSimple(Embeddable.class.getName())};
    private final ScanResultCollector resultCollector;
    private final Indexer indexer;

    public ClassFileArchiveEntryHandler(ScanResultCollector resultCollector) {
        this.resultCollector = resultCollector;
        this.indexer = new Indexer();
    }

    @Override
    public void handleEntry(ArchiveEntry entry, ArchiveContext context) {
        ClassDescriptor classDescriptor = this.toClassDescriptor(entry);
        if (classDescriptor.getCategorization() == ClassDescriptor.Categorization.OTHER) {
            return;
        }
        this.resultCollector.handleClass(classDescriptor, context.isRootUrl());
    }

    private ClassDescriptor toClassDescriptor(ArchiveEntry entry) {
        ClassDescriptor classDescriptor;
        block8: {
            InputStream inputStream = entry.getStreamAccess().accessInputStream();
            try {
                ClassSummary classSummary = this.indexer.indexWithSummary(inputStream);
                Index index = this.indexer.complete();
                classDescriptor = this.toClassDescriptor(classSummary, index, entry);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ArchiveException("Could not build ClassInfo", e);
                }
            }
            inputStream.close();
        }
        return classDescriptor;
    }

    private ClassDescriptor toClassDescriptor(ClassSummary classSummary, Index index, ArchiveEntry entry) {
        ClassDescriptor.Categorization categorization = ClassDescriptor.Categorization.OTHER;
        if (this.isModel(index)) {
            categorization = ClassDescriptor.Categorization.MODEL;
        } else if (this.isConverter(index)) {
            categorization = ClassDescriptor.Categorization.CONVERTER;
        }
        return new ClassDescriptorImpl(classSummary.name().toString(), categorization, entry.getStreamAccess());
    }

    private boolean isConverter(Index index) {
        return !index.getAnnotations(CONVERTER).isEmpty();
    }

    private boolean isModel(Index index) {
        for (DotName model : MODELS) {
            if (index.getAnnotations(model).isEmpty()) continue;
            return true;
        }
        return false;
    }
}

