/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.SingularAttribute;
import jakarta.persistence.metamodel.Type;
import java.io.Serializable;
import java.util.Collection;
import org.hibernate.metamodel.UnsupportedMappingException;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.model.domain.AbstractManagedType;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.internal.EmbeddedDiscriminatorSqmPathSource;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableTypeImpl<J>
extends AbstractManagedType<J>
implements EmbeddableDomainType<J>,
Serializable {
    private final boolean isDynamic;
    private final EmbeddedDiscriminatorSqmPathSource<?> discriminatorPathSource;

    public EmbeddableTypeImpl(JavaType<J> javaType, ManagedDomainType<? super J> superType, DomainType<?> discriminatorType, boolean isDynamic, JpaMetamodelImplementor domainMetamodel) {
        super(javaType.getTypeName(), javaType, superType, domainMetamodel);
        this.isDynamic = isDynamic;
        this.discriminatorPathSource = discriminatorType == null ? null : new EmbeddedDiscriminatorSqmPathSource(discriminatorType, this);
    }

    @Override
    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    @Override
    public int getTupleLength() {
        int count = 0;
        for (SingularAttribute attribute : this.getSingularAttributes()) {
            count += ((DomainType)((Object)attribute.getType())).getTupleLength();
        }
        return count;
    }

    @Override
    public Collection<? extends EmbeddableDomainType<? extends J>> getSubTypes() {
        return super.getSubTypes();
    }

    @Override
    public String getPathName() {
        return this.getTypeName();
    }

    @Override
    public EmbeddableDomainType<J> getSqmPathType() {
        return this;
    }

    @Override
    public SqmPathSource<?> findSubPathSource(String name) {
        PersistentAttribute attribute = this.getSqmPathType().findAttribute(name);
        if (attribute != null) {
            return (SqmPathSource)((Object)attribute);
        }
        PersistentAttribute<?, ?> subtypeAttribute = this.findSubTypesAttribute(name);
        if (subtypeAttribute != null) {
            return (SqmPathSource)((Object)subtypeAttribute);
        }
        if (EntityDiscriminatorMapping.matchesRoleName(name)) {
            return this.discriminatorPathSource;
        }
        return null;
    }

    @Override
    public SqmPath<J> createSqmPath(SqmPath<?> lhs, SqmPathSource<?> intermediatePathSource) {
        throw new UnsupportedMappingException("EmbeddableType cannot be used to create an SqmPath");
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }
}

