/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation;

import BlockDynasty.BukkitImplementation.Integrations.Placeholder.PlaceHolder;
import BlockDynasty.BukkitImplementation.Integrations.vault.Vault;
import BlockDynasty.BukkitImplementation.adapters.ConsoleAdapter;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.TextInput;
import BlockDynasty.BukkitImplementation.adapters.GUI.listener.ClickListener;
import BlockDynasty.BukkitImplementation.adapters.GUI.listener.CloseListener;
import BlockDynasty.BukkitImplementation.adapters.abstractions.BukkitAdapter;
import BlockDynasty.BukkitImplementation.adapters.commands.CommandRegister;
import BlockDynasty.BukkitImplementation.adapters.listeners.PlayerJoinListenerOffline;
import BlockDynasty.BukkitImplementation.adapters.listeners.PlayerJoinListenerOnline;
import BlockDynasty.BukkitImplementation.adapters.proxy.ChannelRegister;
import BlockDynasty.BukkitImplementation.utils.Console;
import BlockDynasty.BukkitImplementation.utils.Updater;
import Main.Economy;
import com.BlockDynasty.bstats.bukkit.Metrics;
import files.Configuration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BlockDynastyEconomy
extends JavaPlugin {
    private static BlockDynastyEconomy instance;
    private final Economy economy = new Economy();
    private static Configuration configuration;
    private Metrics metrics;

    public void onLoad() {
    }

    public void onEnable() {
        instance = this;
        try {
            this.initCoreServices();
            this.registerCommands();
            this.registerEvents();
            this.setupIntegrations();
            Console.log("\u00a7aPlugin enabled successfully!");
        }
        catch (Exception e) {
            Console.logError("An error occurred during plugin initialization: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        try {
            this.metrics = new Metrics((Plugin)this, 27470);
            Updater.check(this, 129308);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onDisable() {
        this.economy.shutdown();
        Vault.unhook();
        PlaceHolder.unregister();
        ChannelRegister.unhook(this);
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    private void initCoreServices() {
        Console.setConsole(new ConsoleAdapter());
        this.economy.init(new TextInput(), new ConsoleAdapter(), new BukkitAdapter());
        configuration = this.economy.getConfiguration();
    }

    private void registerCommands() {
        CommandRegister.registerAll();
    }

    private void registerEvents() {
        PlayerJoinListenerOnline economyListener = new PlayerJoinListenerOnline(this.economy.getPlayerJoinListener());
        if (configuration.getBoolean("online")) {
            if (!this.getServer().getOnlineMode()) {
                Console.logError("THE SERVER IS IN OFFLINE MODE but the plugin is configured to work in ONLINE mode, please change the configuration to avoid issues.");
            }
            economyListener = new PlayerJoinListenerOnline(this.economy.getPlayerJoinListener());
            Console.log("Online mode is enabled. The plugin will use UUID to identify players.");
        }
        if (!configuration.getBoolean("online")) {
            if (this.getServer().getOnlineMode()) {
                Console.logError("THE SERVER IS IN ONLINE MODE but the plugin is configured to work in OFFLINE mode, please change the configuration to avoid issues.");
            }
            economyListener = new PlayerJoinListenerOffline(this.economy.getPlayerJoinListener());
            Console.log("Online mode is disabled, The plugin will use NICKNAME to identify players.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)economyListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ClickListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CloseListener(), (Plugin)this);
    }

    private void setupIntegrations() {
        Vault.init(this.economy.getApiWithLog(this.economy.getVaultLogger()));
        PlaceHolder.register(this.economy.getPlaceHolder());
        ChannelRegister.init(this);
    }

    public static BlockDynastyEconomy getInstance() {
        return instance;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

