/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.Integrations.vault;

import api.EconomyResponse;
import api.IApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class VaultHook
extends AbstractEconomy {
    private IApi api;

    public VaultHook(IApi api) {
        this.api = api;
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "BlockDynastyEconomy";
    }

    public String format(double amount) {
        return this.api.format(new BigDecimal(amount));
    }

    public String currencyNamePlural() {
        return this.api.getDefaultCurrencyNamePlural();
    }

    public String currencyNameSingular() {
        return this.api.getDefaultCurrencyNameSingular();
    }

    public boolean has(String playerName, double amount) {
        return this.api.hasAmount(playerName, BigDecimal.valueOf(amount));
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.has(player.getName(), amount);
    }

    public boolean hasAccount(String playerName) {
        return this.api.existAccount(playerName);
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.api.existAccount(player.getName());
    }

    public double getBalance(String playerName) {
        return this.api.getBalance(playerName).doubleValue();
    }

    public double getBalance(OfflinePlayer player) {
        return this.getBalance(player.getName());
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.withdrawPlayer(player.getName(), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.depositPlayer(player.getName(), amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(String player, double amount) {
        EconomyResponse resultWithdraw = this.api.withdraw(player, BigDecimal.valueOf(amount));
        if (resultWithdraw.isSuccess()) {
            return new net.milkbowl.vault.economy.EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "withdraw success for " + player);
        }
        return new net.milkbowl.vault.economy.EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultWithdraw.getErrorMessage());
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(String player, double amount) {
        EconomyResponse resultDeposit = this.api.deposit(player, BigDecimal.valueOf(amount));
        if (resultDeposit.isSuccess()) {
            return new net.milkbowl.vault.economy.EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "Deposit success for " + player);
        }
        return new net.milkbowl.vault.economy.EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Transaction error" + resultDeposit.getErrorMessage());
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public boolean createPlayerAccount(String playerName) {
        Player player = Bukkit.getPlayer((String)playerName);
        if (player == null) {
            return false;
        }
        return this.api.createAccount(player.getUniqueId(), playerName).isSuccess();
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public net.milkbowl.vault.economy.EconomyResponse withdrawPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.withdrawPlayer(player, amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse depositPlayer(OfflinePlayer player, String worldName, double amount) {
        return this.depositPlayer(player, amount);
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return this.hasAccount(player);
    }

    public boolean has(OfflinePlayer player, String worldName, double amount) {
        return this.has(player, amount);
    }

    public net.milkbowl.vault.economy.EconomyResponse createBank(String name, String player) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse deleteBank(String name) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse bankHas(String name, double amount) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse bankWithdraw(String name, double amount) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse bankDeposit(String name, double amount) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankOwner(String name, String playerName) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse isBankMember(String name, String playerName) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public net.milkbowl.vault.economy.EconomyResponse bankBalance(String name) {
        return new net.milkbowl.vault.economy.EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "BlockDynastyEconomy does not support bank accounts!");
    }

    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return -1;
    }
}

