/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.GUI.adapters;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.utils.Version;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lib.gui.components.Materials;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MaterialAdapter {
    private static final Map<Materials, Material> MATERIAL_MAP = new HashMap<Materials, Material>();
    private static final Material FALLBACK = Material.STONE;

    public static Material toBukkitMaterial(Materials material) {
        return MATERIAL_MAP.getOrDefault((Object)material, FALLBACK);
    }

    public static ItemStack toBukkitItemStack(Materials materials) {
        if (Version.isLegacy()) {
            switch (materials) {
                case PLAYER_HEAD: {
                    return new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
                }
                case BLUE_STAINED_GLASS_PANE: {
                    return new ItemStack(Material.valueOf((String)"STAINED_GLASS_PANE"), 1, 11);
                }
            }
            if (materials.name().contains("WOOL")) {
                return new ItemStack(Material.valueOf((String)"WOOL"), 1, MaterialAdapter.getLegacyDataValue(materials.name()));
            }
        }
        return new ItemStack(MaterialAdapter.toBukkitMaterial(materials));
    }

    public static void applyItemMeta(ItemStack item, String displayName, List<String> lore) {
        ItemMeta meta;
        if (MaterialAdapter.isPlayerHead(item.getType())) {
            SkullMeta skullMeta = (SkullMeta)item.getItemMeta();
            if (MaterialAdapter.isValidPlayerName(displayName)) {
                skullMeta.setOwner(displayName);
            }
            meta = skullMeta;
        } else {
            meta = item.getItemMeta();
        }
        if (displayName != null) {
            if (!Version.hasSupportAdventureText() || BlockDynastyEconomy.getConfiguration().getBoolean("forceVanillaColorsSystem")) {
                meta.setDisplayName(displayName);
            } else {
                meta.displayName(MiniMessage.miniMessage().deserialize((Object)displayName));
            }
        }
        if (lore != null) {
            if (!Version.hasSupportAdventureText() || BlockDynastyEconomy.getConfiguration().getBoolean("forceVanillaColorsSystem")) {
                meta.setLore(lore);
            } else {
                List loreComponents = lore.stream().map(m -> MiniMessage.miniMessage().deserialize(m)).collect(Collectors.toList());
                meta.lore(loreComponents);
            }
        }
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        item.setItemMeta(meta);
    }

    private static boolean isValidPlayerName(String name) {
        if (name == null) {
            return false;
        }
        return name.matches("^[a-zA-Z0-9_]{3,16}$");
    }

    private static boolean isPlayerHead(Material material) {
        if (Version.isLegacy()) {
            return material == Material.valueOf((String)"SKULL_ITEM");
        }
        return material == Material.PLAYER_HEAD;
    }

    public static Sound getClickSound() {
        if (Version.match("1.8", "1.9", "1.10", "1.11")) {
            return Sound.valueOf((String)"CLICK");
        }
        return Sound.UI_BUTTON_CLICK;
    }

    public static Sound getPickupSound() {
        if (Version.match("1.8", "1.9", "1.10", "1.11")) {
            return Sound.valueOf((String)"ORB_PICKUP");
        }
        return Sound.ENTITY_EXPERIENCE_ORB_PICKUP;
    }

    private static short getLegacyDataValue(String material) {
        switch (material) {
            case "WHITE_WOOL": {
                return 0;
            }
            case "ORANGE_WOOL": {
                return 1;
            }
            case "MAGENTA_WOOL": {
                return 2;
            }
            case "LIGHT_BLUE_WOOL": {
                return 3;
            }
            case "YELLOW_WOOL": {
                return 4;
            }
            case "LIME_WOOL": {
                return 5;
            }
            case "PINK_WOOL": {
                return 6;
            }
            case "GRAY_WOOL": {
                return 7;
            }
            case "LIGHT_GRAY_WOOL": {
                return 8;
            }
            case "CYAN_WOOL": {
                return 9;
            }
            case "PURPLE_WOOL": {
                return 10;
            }
            case "BLUE_WOOL": {
                return 11;
            }
            case "BROWN_WOOL": {
                return 12;
            }
            case "GREEN_WOOL": {
                return 13;
            }
            case "RED_WOOL": {
                return 14;
            }
            case "BLACK_WOOL": {
                return 15;
            }
        }
        return 0;
    }

    static {
        for (Materials material : Materials.values()) {
            try {
                Material bukkitMaterial = Material.valueOf((String)material.name());
                MATERIAL_MAP.put(material, bukkitMaterial);
            }
            catch (IllegalArgumentException e) {
                if (Version.isLegacy()) {
                    if (material == Materials.PLAYER_HEAD) {
                        MATERIAL_MAP.put(material, Material.valueOf((String)"SKULL_ITEM"));
                    }
                    if (material.name().contains("WOOL")) {
                        MATERIAL_MAP.put(material, Material.valueOf((String)"WOOL"));
                    }
                    if (material == Materials.LIME_DYE) {
                        MATERIAL_MAP.put(material, Material.SLIME_BALL);
                    }
                    if (material == Materials.LIME_CONCRETE) {
                        MATERIAL_MAP.put(material, Material.EMERALD_BLOCK);
                    }
                    if (material == Materials.RED_CONCRETE) {
                        MATERIAL_MAP.put(material, Material.REDSTONE_BLOCK);
                    }
                    if (material == Materials.WRITABLE_BOOK) {
                        MATERIAL_MAP.put(material, Material.valueOf((String)"BOOK_AND_QUILL"));
                    }
                    if (material == Materials.GLASS_PANE) {
                        MATERIAL_MAP.put(material, Material.valueOf((String)"THIN_GLASS"));
                    }
                    if (material != Materials.BLUE_STAINED_GLASS_PANE) continue;
                    MATERIAL_MAP.put(material, Material.valueOf((String)"STAINED_GLASS_PANE"));
                    continue;
                }
                MATERIAL_MAP.put(material, FALLBACK);
            }
        }
    }
}

