/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.abstractions;

import BlockDynasty.BukkitImplementation.BlockDynastyEconomy;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.InventoryAdapter;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.ItemStackAdapter;
import BlockDynasty.BukkitImplementation.adapters.GUI.adapters.MaterialAdapter;
import BlockDynasty.BukkitImplementation.adapters.abstractions.EntityPlayerAdapter;
import BlockDynasty.BukkitImplementation.scheduler.Scheduler;
import BlockDynasty.BukkitImplementation.scheduler.SchedulerFactory;
import BlockDynasty.BukkitImplementation.utils.Version;
import java.io.File;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lib.abstractions.IPlayer;
import lib.abstractions.PlatformAdapter;
import lib.gui.components.IInventory;
import lib.gui.components.IItemStack;
import lib.gui.components.Materials;
import lib.scheduler.ContextualTask;
import lib.scheduler.IScheduler;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitAdapter
implements PlatformAdapter {
    @Override
    public IPlayer getPlayer(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            return null;
        }
        return EntityPlayerAdapter.of(player);
    }

    @Override
    public void dispatchCommand(String command) {
        Scheduler.run(ContextualTask.build(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command)));
    }

    @Override
    public void sendPluginMessage(String channel, byte[] message) {
        Bukkit.getServer().sendPluginMessage((Plugin)BlockDynastyEconomy.getInstance(), channel, message);
    }

    @Override
    public IScheduler getScheduler() {
        return SchedulerFactory.getScheduler();
    }

    @Override
    public File getDataFolder() {
        return BlockDynastyEconomy.getInstance().getDataFolder();
    }

    @Override
    public boolean isLegacy() {
        return Version.isLegacy();
    }

    @Override
    public boolean hasSupportAdventureText() {
        return Version.hasSupportAdventureText();
    }

    @Override
    public IItemStack createItemStack(Materials material) {
        ItemStack itemStack = MaterialAdapter.toBukkitItemStack(material);
        return new ItemStackAdapter(itemStack);
    }

    @Override
    public IInventory createInventory(String title, int rows) {
        Inventory inventory = Bukkit.createInventory(null, (int)(rows * 9), (String)title);
        return new InventoryAdapter(inventory);
    }

    @Override
    public IPlayer getPlayerByUUID(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return null;
        }
        return EntityPlayerAdapter.of(player);
    }

    @Override
    public List<IPlayer> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().stream().map(EntityPlayerAdapter::of).collect(Collectors.toList());
    }
}

