/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.adapters.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabCompletionAdapter
implements TabCompleter {
    private final lib.commands.abstractions.Command rootCommand;

    public TabCompletionAdapter(lib.commands.abstractions.Command command) {
        this.rootCommand = command;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        String arg;
        lib.commands.abstractions.Command nextCommand;
        lib.commands.abstractions.Command currentCommand = this.rootCommand;
        int subcommandEndPosition = 0;
        for (int i = 0; i < args.length - 1 && (nextCommand = this.findSubCommand(currentCommand, arg = args[i])) != null; ++i) {
            currentCommand = nextCommand;
            subcommandEndPosition = i + 1;
        }
        if (args.length - 1 == subcommandEndPosition && !currentCommand.getSubCommands().isEmpty()) {
            String partialArg = args[args.length - 1].toLowerCase();
            return currentCommand.getSubCommands().stream().map(lib.commands.abstractions.Command::getName).filter(name -> name.toLowerCase().startsWith(partialArg)).collect(Collectors.toList());
        }
        List<String> commandArgs = currentCommand.getArgs();
        if (commandArgs == null || commandArgs.isEmpty()) {
            return new ArrayList<String>();
        }
        int argIndex = args.length - 1 - subcommandEndPosition;
        if (argIndex >= commandArgs.size()) {
            return new ArrayList<String>();
        }
        String currentArgType = commandArgs.get(argIndex);
        if (currentArgType.equals("player")) {
            String partialArg = args[args.length - 1].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialArg)).collect(Collectors.toList());
        }
        String partialArg = args[args.length - 1].toLowerCase();
        if (currentArgType.toLowerCase().startsWith(partialArg)) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(currentArgType);
            return result;
        }
        return new ArrayList<String>();
    }

    private lib.commands.abstractions.Command findSubCommand(lib.commands.abstractions.Command parent, String commandName) {
        if (parent == null || parent.getSubCommands() == null || parent.getSubCommands().isEmpty()) {
            return null;
        }
        return parent.getSubCommands().stream().filter(cmd -> cmd.getName().equalsIgnoreCase(commandName)).findFirst().orElse(null);
    }
}

