/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.BukkitImplementation.utils;

import BlockDynasty.BukkitImplementation.scheduler.Scheduler;
import BlockDynasty.BukkitImplementation.utils.Console;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import lib.scheduler.ContextualTask;
import org.bukkit.plugin.java.JavaPlugin;

public class Updater {
    private int project = -1;
    private URL checkURL;
    private String newVersion;
    private String currentVersion;
    private JavaPlugin plugin;

    private Updater(JavaPlugin plugin, int project) {
        this.project = project;
        this.plugin = plugin;
        this.currentVersion = plugin.getDescription().getVersion();
        try {
            this.checkURL = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + project);
        }
        catch (MalformedURLException ex) {
            Console.logError("Invalid URL for updater.");
        }
    }

    private String getResourceURL() {
        return "https://www.spigotmc.org/resources/" + this.project;
    }

    private boolean checkForUpdates() {
        if (this.checkURL == null) {
            return false;
        }
        try {
            URLConnection con = this.checkURL.openConnection();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                this.newVersion = reader.readLine();
            }
            return this.newVersion != null && !this.newVersion.equalsIgnoreCase(this.currentVersion);
        }
        catch (IOException e) {
            Console.log("Can't check update: " + e.getMessage());
            return false;
        }
    }

    private void checkAsync() {
        Scheduler.run(ContextualTask.build(() -> {
            if (this.checkForUpdates()) {
                Console.log("\u00a1New version Available : " + this.newVersion + "!");
                Console.log("Download in: " + this.getResourceURL());
            } else {
                Console.log("The plugin is Updated");
            }
        }));
    }

    public static Updater check(JavaPlugin plugin, int project) {
        if (project == -1) {
            return null;
        }
        Updater updater = new Updater(plugin, project);
        updater.checkAsync();
        return updater;
    }
}

