/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.currency;

import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.currency.Exceptions.CurrencyNotFoundException;
import BlockDynasty.Economy.domain.persistence.Exceptions.TransactionException;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.ICurrencyService;
import BlockDynasty.Economy.domain.services.courier.Courier;

public class DeleteCurrencyUseCase {
    private final ICurrencyService currencyService;
    private final IAccountService accountService;
    private final IRepository dataStore;
    private final Courier updateForwarder;

    public DeleteCurrencyUseCase(ICurrencyService currencyService, IAccountService accountService, IRepository dataStore, Courier updateForwarder) {
        this.currencyService = currencyService;
        this.accountService = accountService;
        this.dataStore = dataStore;
        this.updateForwarder = updateForwarder;
    }

    public void deleteCurrency(String currencyName) {
        Currency currency = this.currencyService.getCurrency(currencyName);
        if (currency == null) {
            throw new CurrencyNotFoundException("Currency not found");
        }
        if (currency.isDefaultCurrency()) {
            throw new CurrencyNotFoundException(currency.getSingular() + " is default");
        }
        try {
            this.dataStore.deleteCurrency(currency);
            this.currencyService.remove(currency);
            this.accountService.syncDbWithOnlineAccounts();
            if (this.updateForwarder != null) {
                this.updateForwarder.sendUpdateMessage("currency", currency.getUuid().toString());
            }
        }
        catch (TransactionException e) {
            throw new TransactionException("Error deleting currency");
        }
    }
}

