/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.aplication.useCase.transaction;

import BlockDynasty.Economy.aplication.events.EventManager;
import BlockDynasty.Economy.aplication.useCase.account.SearchAccountUseCase;
import BlockDynasty.Economy.aplication.useCase.currency.SearchCurrencyUseCase;
import BlockDynasty.Economy.domain.entities.account.Account;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.events.Context;
import BlockDynasty.Economy.domain.events.transactionsEvents.DepositEvent;
import BlockDynasty.Economy.domain.persistence.entities.IRepository;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import BlockDynasty.Economy.domain.services.IAccountService;
import BlockDynasty.Economy.domain.services.courier.Courier;
import BlockDynasty.Economy.domain.services.log.Log;
import java.math.BigDecimal;
import java.util.UUID;

public class DepositUseCase {
    private final SearchCurrencyUseCase searchCurrencyUseCase;
    private final IRepository dataStore;
    private final Courier updateForwarder;
    private final EventManager eventManager;
    private final Log logger;
    private final SearchAccountUseCase searchAccountUseCase;
    private final IAccountService accountService;

    public DepositUseCase(SearchCurrencyUseCase searchCurrencyUseCase, SearchAccountUseCase searchAccountUseCase, IAccountService accountService, IRepository dataStore, Courier updateForwarder, Log logger2, EventManager eventManager) {
        this.searchCurrencyUseCase = searchCurrencyUseCase;
        this.accountService = accountService;
        this.dataStore = dataStore;
        this.updateForwarder = updateForwarder;
        this.logger = logger2;
        this.eventManager = eventManager;
        this.searchAccountUseCase = searchAccountUseCase;
    }

    public Result<Void> execute(UUID targetUUID, BigDecimal amount) {
        return this.execute(targetUUID, null, amount);
    }

    public Result<Void> execute(String targetName, BigDecimal amount) {
        return this.execute(targetName, null, amount);
    }

    public Result<Void> execute(UUID targetUUID, String currencyName, BigDecimal amount) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(targetUUID);
        return this.execute(accountResult, currencyName, amount, Context.OTHER);
    }

    public Result<Void> execute(String targetName, String currencyName, BigDecimal amount) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(targetName);
        return this.execute(accountResult, currencyName, amount, Context.OTHER);
    }

    public Result<Void> execute(UUID targetUUID, String currencyName, BigDecimal amount, Context context) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(targetUUID);
        return this.execute(accountResult, currencyName, amount, context);
    }

    public Result<Void> execute(String targetName, String currencyName, BigDecimal amount, Context context) {
        Result<Account> accountResult = this.searchAccountUseCase.getAccount(targetName);
        return this.execute(accountResult, currencyName, amount, context);
    }

    private Result<Void> execute(Result<Account> accountResult, String currencyName, BigDecimal amount, Context context) {
        Result<Currency> currencyResult;
        if (!accountResult.isSuccess()) {
            return Result.failure(accountResult.getErrorMessage(), accountResult.getErrorCode());
        }
        Result<Currency> result = currencyResult = currencyName == null ? this.searchCurrencyUseCase.getDefaultCurrency() : this.searchCurrencyUseCase.getCurrency(currencyName);
        if (!currencyResult.isSuccess()) {
            return Result.failure(currencyResult.getErrorMessage(), currencyResult.getErrorCode());
        }
        return this.performDeposit(accountResult.getValue(), currencyResult.getValue(), amount, context);
    }

    private Result<Void> performDeposit(Account account, Currency currency, BigDecimal amount, Context context) {
        if (!account.canReceiveCurrency()) {
            return Result.failure("Account can't receive currency", ErrorCode.ACCOUNT_CAN_NOT_RECEIVE);
        }
        if (account.isBlocked()) {
            return Result.failure("Account is blocked", ErrorCode.ACCOUNT_BLOCKED);
        }
        if (amount.compareTo(BigDecimal.ZERO) <= 0) {
            return Result.failure("Amount must be greater than 0", ErrorCode.INVALID_AMOUNT);
        }
        if (!currency.isValidAmount(amount)) {
            return Result.failure("Decimal not supported", ErrorCode.DECIMAL_NOT_SUPPORTED);
        }
        Result<Account> result = this.dataStore.deposit(account.getUuid().toString(), currency, amount);
        if (!result.isSuccess()) {
            this.logger.log("[DEPOSIT failed] Account: " + account.getNickname() + " recibi\u00f3 un deposito de " + currency.format(amount) + " de " + currency.getSingular() + " pero fall\u00f3: " + result.getErrorMessage() + " (" + String.valueOf((Object)result.getErrorCode()) + ")");
            return Result.failure(result.getErrorMessage(), result.getErrorCode());
        }
        this.accountService.syncOnlineAccount(result.getValue());
        this.updateForwarder.sendUpdateMessage("event", new DepositEvent(account.getPlayer(), currency, amount, context).toJson(), account.getPlayer().getUuid().toString());
        this.logger.log("[DEPOSIT] Account: " + account.getNickname() + " has received a deposit of " + currency.format(amount) + " " + currency.getSingular());
        this.eventManager.emit(new DepositEvent(account.getPlayer(), currency, amount, context));
        return Result.success();
    }
}

