/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.account;

import BlockDynasty.Economy.domain.entities.account.IAccount;
import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.balance.Money;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.wallet.Wallet;
import BlockDynasty.Economy.domain.result.ErrorCode;
import BlockDynasty.Economy.domain.result.Result;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;

public class Account
implements IAccount {
    private final Player player;
    private Wallet wallet;
    private boolean canReceiveCurrency;
    private boolean blocked;

    public Account(UUID uuid, String nickname) {
        this.player = new Player(uuid, nickname);
        this.wallet = new Wallet();
        this.blocked = false;
        this.canReceiveCurrency = true;
    }

    public Account(UUID uuid, String nickname, List<Money> moneyList, boolean canReceiveCurrency, boolean blocked) {
        this.player = new Player(uuid, nickname);
        this.wallet = new Wallet(moneyList);
        this.canReceiveCurrency = canReceiveCurrency;
        this.blocked = blocked;
    }

    public Account(UUID uuid, String nickname, Wallet wallet, boolean canReceiveCurrency, boolean blocked) {
        this.player = new Player(uuid, nickname);
        this.wallet = wallet;
        this.canReceiveCurrency = canReceiveCurrency;
        this.blocked = blocked;
    }

    public Account(Account account) {
        this.player = new Player(account.getPlayer());
        this.wallet = new Wallet(account.getWallet());
        this.canReceiveCurrency = account.canReceiveCurrency();
        this.blocked = account.isBlocked();
    }

    @Override
    public Result<Void> subtract(Currency currency, BigDecimal amount) {
        Money money = this.getMoney(currency);
        if (money == null) {
            return Result.failure("No balance found for currency", ErrorCode.ACCOUNT_NOT_HAVE_BALANCE);
        }
        Result<Void> result = money.subtract(amount);
        if (!result.isSuccess()) {
            return result;
        }
        return Result.success(null);
    }

    @Override
    public Result<Void> add(Currency currency, BigDecimal amount) {
        Money money = this.getMoney(currency);
        if (money == null) {
            return Result.failure("No balance found for currency", ErrorCode.ACCOUNT_NOT_HAVE_BALANCE);
        }
        Result<Void> result = money.add(amount);
        if (!result.isSuccess()) {
            return result;
        }
        return Result.success(null);
    }

    @Override
    public Result<Void> setMoney(Currency currency, BigDecimal amount) {
        Money money = this.getMoney(currency);
        if (money == null) {
            this.createBalance(currency, amount);
        } else {
            Result<Void> result = money.setAmount(amount);
            if (!result.isSuccess()) {
                return result;
            }
        }
        return Result.success(null);
    }

    @Override
    public void setBalances(List<Money> monies) {
        this.wallet.setBalances(monies);
    }

    public List<Money> getBalances() {
        return this.wallet.getBalances();
    }

    @Override
    public boolean hasCurrency(String currencyName) {
        return this.wallet.hasCurrency(currencyName);
    }

    @Override
    public Money getMoney(Currency currency) {
        return this.wallet.getMoney(currency);
    }

    @Override
    public Money getMoney() {
        return this.wallet.getMoney();
    }

    @Override
    public Money getMoney(String currencyName) {
        return this.wallet.getMoney(currencyName);
    }

    @Override
    public boolean hasEnough(Currency currency, BigDecimal amount) {
        Money money = this.getMoney(currency);
        if (money == null) {
            return false;
        }
        return money.hasEnough(amount);
    }

    @Override
    public Wallet getWallet() {
        return this.wallet;
    }

    @Override
    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    @Override
    public boolean hasEnoughDefaultCurrency(BigDecimal amount) {
        Money money = this.getMoney();
        if (money == null) {
            return false;
        }
        return money.hasEnough(amount);
    }

    private void createBalance(Currency currency, BigDecimal amount) {
        this.wallet.createBalance(currency, amount);
    }

    @Override
    public void setUuid(UUID uuid) {
        this.player.setUuid(uuid);
    }

    @Override
    public void setNickname(String nickname) {
        this.player.setNickname(nickname);
    }

    @Override
    public String getNickname() {
        return this.player.getNickname();
    }

    @Override
    public UUID getUuid() {
        return this.player.getUuid();
    }

    @Override
    public void setCanReceiveCurrency(boolean canReceiveCurrency) {
        this.canReceiveCurrency = canReceiveCurrency;
    }

    @Override
    public boolean canReceiveCurrency() {
        return this.canReceiveCurrency;
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public void block() {
        this.blocked = true;
    }

    public void unblock() {
        this.blocked = false;
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    public String toString() {
        return "Account{player=" + String.valueOf(this.player) + ", wallet=" + String.valueOf(this.wallet) + ", canReceiveCurrency=" + this.canReceiveCurrency + "}";
    }
}

