/*
 * Decompiled with CFR 0.152.
 */
package BlockDynasty.Economy.domain.entities.offers;

import BlockDynasty.Economy.domain.entities.account.Player;
import BlockDynasty.Economy.domain.entities.currency.Currency;
import BlockDynasty.Economy.domain.entities.offers.IOffer;
import java.math.BigDecimal;
import java.util.Objects;

public class Offer
implements IOffer {
    private Player vendedor;
    private Player comprador;
    private BigDecimal cantidad;
    private Currency tipoCantidad;
    private BigDecimal monto;
    private Currency tipoMonto;

    public Offer(Player vendedor, Player comprador, BigDecimal cantidad, BigDecimal monto, Currency tipoCantidad, Currency tipoMonto) {
        this.vendedor = vendedor;
        this.comprador = comprador;
        this.cantidad = cantidad;
        this.tipoCantidad = tipoCantidad;
        this.monto = monto;
        this.tipoMonto = tipoMonto;
    }

    @Override
    public Player getVendedor() {
        return this.vendedor;
    }

    @Override
    public Player getComprador() {
        return this.comprador;
    }

    @Override
    public BigDecimal getCantidad() {
        return this.cantidad;
    }

    @Override
    public Currency getTipoCantidad() {
        return this.tipoCantidad;
    }

    @Override
    public BigDecimal getMonto() {
        return this.monto;
    }

    @Override
    public Currency getTipoMonto() {
        return this.tipoMonto;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.vendedor.getUuid().toString(), this.comprador.getUuid().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Offer offer = (Offer)o;
        return Objects.equals(this.vendedor.getUuid().toString(), offer.vendedor.getUuid().toString()) && Objects.equals(this.comprador.getUuid().toString(), offer.comprador.getUuid().toString());
    }
}

